/*
**-----------------------------------------------------------------------
**
**  copy_vects()
**
**  This function will initialise the shadow vector table by inserting
**  jump instructions at each of the 108 shadow vector address.
**
**  The address value 0x200000L is the start of the external SRAM. For
**  custom builds, or mode 7 execution this should be modified 
**  accordingly.
**
**-----------------------------------------------------------------------
*/
void copy_vects(void)
{
	volatile int iVect;
	
	/* Initialise the shadow vector table with Jump (0x5a) instructions */
	for (iVect = 0; iVect < 108; iVect++)
	{
		(*(volatile unsigned char *)(0x200000L + (unsigned long)(iVect * 4))) = (unsigned char)0x5a;
	}
}   
