package opc.ua.addressspace.datatype;

public class NodeId {
	
	/** fe. “http://opcfoundation.org/UA/” **/
	private int namespaceIndex;
	
	/**
	 * NUMERIC_0	... Numeric value 
	 * STRING_1		... String value
	 * GUID_2		... Globally unique identifier
	 * OPAQUE_3		... Namespace specific format
	 */
	private String identifierType;
	
	/**
	 * These are the vaules of null nodes
	 * NUMERIC_0	... 0 
	 * STRING_1		... null or empty string
	 * GUID_2		... guid initialised with zeroes
	 * OPAQUE_3		... byte string with length = 0
	 */
	private String identifier;
	
	
	public NodeId() {
		
	}
	
	public NodeId(String identifier) {
		this.identifierType = "STRING";
		this.identifier = identifier;
	}
	
	public int getNamespaceIndex() {
		return namespaceIndex;
	}
	
	public void setNamespaceIndex(int namespaceIndex) {
		this.namespaceIndex = namespaceIndex;
	}
	
	public String getIdentifierType() {
		return identifierType;
	}
	
	public void setIdentifierType(String identifierType) {
		this.identifierType = identifierType;
	}
	
	public String getIdentifier() {
		return identifier;
	}
	
	public void setIdentifier(String identifier) {
		this.identifier = identifier;
	}
	
}
