package opc.ua.addressspace.nodeclasse;

import opc.ua.addressspace.datatype.LocalizedText;
import opc.ua.addressspace.datatype.NodeId;
import opc.ua.addressspace.datatype.QualifiedName;

public class BaseNode {
	
	/**
	 * attributes
	 */
	private NodeId nodeId;
	
	/**
	 * OBJECT_1
	 * VARIABLE_2
	 * METHOD_4
	 * OBJECT_TYPE_8
	 * VARIABLE_TYPE_16
	 * REFERENCE_TYPE_32
	 * DATA_TYPE_64
	 * VIEW_128
	**/
	private String nodeClass;
	
	private QualifiedName browseName;
	private LocalizedText displayName;
	private LocalizedText description;
	private long writeMask;
	private long userWriteMask;

	public BaseNode() {
		
	}
	
	public BaseNode(String browseName) {
		this.browseName = new QualifiedName(browseName);
	}

	public NodeId getNodeId() {
		return nodeId;
	}
	
	public void setNodeId(NodeId nodeId) {
		this.nodeId = nodeId;
	}
	
	public String getNodeClass() {
		return nodeClass;
	}
	
	public void setNodeClass(String nodeClass) {
		this.nodeClass = nodeClass;
	}
	
	public QualifiedName getBrowseName() {
		return browseName;
	}
	
	public void setBrowseName(QualifiedName browseName) {
		this.browseName = browseName;
	}

	public void setBrowseName(String browseName) {
		this.browseName = new QualifiedName(browseName);
	}
	
	public LocalizedText getDisplayName() {
		return displayName;
	}
	
	public void setDisplayName(LocalizedText displayName) {
		this.displayName = displayName;
	}
	
	public LocalizedText getDescription() {
		return description;
	}
	
	public void setDescription(LocalizedText description) {
		this.description = description;
	}
	
	public long getWriteMask() {
		return writeMask;
	}
	
	public void setWriteMask(long writeMask) {
		this.writeMask = writeMask;
	}
	
	public long getUserWriteMask() {
		return userWriteMask;
	}
	
	public void setUserWriteMask(long userWriteMask) {
		this.userWriteMask = userWriteMask;
	}
	
}
