package opc.ua.addressspace.nodeclasse;

import java.awt.Image;

public class ObjectTypeNode extends BaseNode {

	/**
	 * attributes
	 */
	private boolean isAbstract;
	
	/**
	 * references
	 */
	/** 
	 * OPC UA Part 3, p.36
	 */
	private BaseNode[] hasComponent;
	private BaseNode[] hasProperty;
	private BaseNode[] hasSubtype;
	private BaseNode[] generatesEvent;
	//other references
	
	/**
	 * properties
	 */
	private String nodeVersion;
	private Image icon;
	
	public ObjectTypeNode() {
		
	}
	
	public ObjectTypeNode(String browseName) {
		super(browseName);
	}

	public ObjectTypeNode(String browseName, boolean isAbstract) {
		this(browseName);
		setAbstract(isAbstract);
	}

	public boolean isAbstract() {
		return isAbstract;
	}
	public void setAbstract(boolean isAbstract) {
		this.isAbstract = isAbstract;
	}
	public BaseNode[] getHasComponent() {
		return hasComponent;
	}
	public void setHasComponent(BaseNode[] hasComponent) {
		this.hasComponent = hasComponent;
	}
	public BaseNode[] getHasProperty() {
		return hasProperty;
	}
	public void setHasProperty(BaseNode[] hasProperty) {
		this.hasProperty = hasProperty;
	}
	public BaseNode[] getHasSubtype() {
		return hasSubtype;
	}
	public void setHasSubtype(BaseNode[] hasSubtype) {
		this.hasSubtype = hasSubtype;
	}
	public BaseNode[] getGeneratesEvent() {
		return generatesEvent;
	}
	public void setGeneratesEvent(BaseNode[] generatesEvent) {
		this.generatesEvent = generatesEvent;
	}
	public String getNodeVersion() {
		return nodeVersion;
	}
	public void setNodeVersion(String nodeVersion) {
		this.nodeVersion = nodeVersion;
	}
	public Image getIcon() {
		return icon;
	}
	public void setIcon(Image icon) {
		this.icon = icon;
	}
}
