package opc.ua.addressspace.nodeclasse;

import opc.ua.addressspace.datatype.LocalizedText;

public class ReferenceTypeNode extends BaseNode {

	/**
	 * attributes
	 */
	private boolean isAbstract;
	private boolean symmetric;
	private LocalizedText inverseName;
	
	/**
	 * references
	 */
	/**
	 * OPC UA PART 3 - p.31
	 */
	private BaseNode[] hasProperty;
	private BaseNode[] hasSubtype;
	
	/**
	 * properties
	 */
	private String nodeVersion;

	public boolean isAbstract() {
		return isAbstract;
	}

	public void setAbstract(boolean isAbstract) {
		this.isAbstract = isAbstract;
	}

	public boolean isSymmetric() {
		return symmetric;
	}

	public void setSymmetric(boolean symmetric) {
		this.symmetric = symmetric;
	}

	public LocalizedText getInverseName() {
		return inverseName;
	}

	public void setInverseName(LocalizedText inverseName) {
		this.inverseName = inverseName;
	}

	public void setInverseName(String inverseName) {
		this.inverseName = new LocalizedText(inverseName);
	}

	public BaseNode[] getHasProperty() {
		return hasProperty;
	}

	public void setHasProperty(BaseNode[] hasProperty) {
		this.hasProperty = hasProperty;
	}

	public BaseNode[] getHasSubtype() {
		return hasSubtype;
	}

	public void setHasSubtype(BaseNode[] hasSubtype) {
		this.hasSubtype = hasSubtype;
	}

	public String getNodeVersion() {
		return nodeVersion;
	}

	public void setNodeVersion(String nodeVersion) {
		this.nodeVersion = nodeVersion;
	}
}
