package opc.ua.addressspace.nodeclasse;

import opc.ua.addressspace.datatype.NodeId;
import opc.ua.addressspace.datatype.TimeZone;

public class VariableNode extends BaseNode {

	/**
	 * attributes
	 */
	/**
	 * defined by dataType
	 */
	private Object value;
	
	private NodeId dataType;
	private int valueRank;
	private long[] arrayDimensions;
	
	/**
	 * Field          Bit Description
		CurrentRead    0   Indicates if the current value is
		                   readable
		                   (0 means not readable, 1 means
		                   readable).
		CurrentWrite   1   Indicates if the current value is
		                   writable
		                   (0 means not writable, 1 means
		                   writable).
		HistoryRead    2   Indicates if the history of the value
		                   is readable
		                   (0 means not readable, 1 means
		                   readable).
		HistoryWrite   3   Indicates if the history of the value
		                   is writable (0 means not writable, 1
		                   means writable).
		SemanticChange 4   Indicates if the Variable used as
		                   Property generates
		                   SemanticChangeEvents (see
		                   9.31).
		Reserved       5:7 Reserved for future use. Shall
		                   always be zero.
	 */
	private byte accessLevel;
	
	/**
	 * Field        Bit Description
		CurrentRead  0   Indicates if the current value is readable
		                 (0 means not readable, 1 means readable).
		CurrentWrite 1   Indicates if the current value is writable
		                 (0 means not writable, 1 means writable).
		HistoryRead  2   Indicates if the history of the value is
		                 readable
		                 (0 means not readable, 1 means readable).
		HistoryWrite 3   Indicates if the history of the value is writable
		                 (0 means not writable, 1 means writable).
		Reserved     4:7 Reserved for future use. Shall always be
		                 zero.
	 */
	private byte userAccessLevel;
	
	private double minimumSamplingInterval;
	private boolean historizing;
	
	/**
	 * references
	 */
	/** 
	 * OPC UA Part 3, p.39
	 */
	private BaseNode hasModellingRule;
	private BaseNode[] hasProperty;
	private BaseNode[] hasComponent;
	private BaseNode hasTypeDefinition;
	private BaseNode hasModelParent;
	// other references 
	
	/**
	 * properties
	 */
	private String nodeVersion;
	private TimeZone localTime;
	private String dataTypeVersion;
	private byte[] dictionaryFragment;
	private boolean allowNulls;
	
	
	public Object getValue() {
		return value;
	}
	public void setValue(Object value) {
		this.value = value;
	}
	public NodeId getDataType() {
		return dataType;
	}
	public void setDataType(NodeId dataType) {
		this.dataType = dataType;
	}
	public int getValueRank() {
		return valueRank;
	}
	public void setValueRank(int valueRank) {
		this.valueRank = valueRank;
	}
	public long[] getArrayDimensions() {
		return arrayDimensions;
	}
	public void setArrayDimensions(long[] arrayDimensions) {
		this.arrayDimensions = arrayDimensions;
	}
	public byte getAccessLevel() {
		return accessLevel;
	}
	public void setAccessLevel(byte accessLevel) {
		this.accessLevel = accessLevel;
	}
	public byte getUserAccessLevel() {
		return userAccessLevel;
	}
	public void setUserAccessLevel(byte userAccessLevel) {
		this.userAccessLevel = userAccessLevel;
	}
	public double getMinimumSamplingInterval() {
		return minimumSamplingInterval;
	}
	public void setMinimumSamplingInterval(double minimumSamplingInterval) {
		this.minimumSamplingInterval = minimumSamplingInterval;
	}
	public boolean isHistorizing() {
		return historizing;
	}
	public void setHistorizing(boolean historizing) {
		this.historizing = historizing;
	}
	public BaseNode getHasModellingRule() {
		return hasModellingRule;
	}
	public void setHasModellingRule(BaseNode hasModellingRule) {
		this.hasModellingRule = hasModellingRule;
	}
	public BaseNode[] getHasProperty() {
		return hasProperty;
	}
	public void setHasProperty(BaseNode[] hasProperty) {
		this.hasProperty = hasProperty;
	}
	public BaseNode[] getHasComponent() {
		return hasComponent;
	}
	public void setHasComponent(BaseNode[] hasComponent) {
		this.hasComponent = hasComponent;
	}
	public BaseNode getHasTypeDefinition() {
		return hasTypeDefinition;
	}
	public void setHasTypeDefinition(BaseNode hasTypeDefinition) {
		this.hasTypeDefinition = hasTypeDefinition;
	}
	public BaseNode getHasModelParent() {
		return hasModelParent;
	}
	public void setHasModelParent(BaseNode hasModelParent) {
		this.hasModelParent = hasModelParent;
	}
	public String getNodeVersion() {
		return nodeVersion;
	}
	public void setNodeVersion(String nodeVersion) {
		this.nodeVersion = nodeVersion;
	}
	public TimeZone getLocalTime() {
		return localTime;
	}
	public void setLocalTime(TimeZone localTime) {
		this.localTime = localTime;
	}
	public String getDataTypeVersion() {
		return dataTypeVersion;
	}
	public void setDataTypeVersion(String dataTypeVersion) {
		this.dataTypeVersion = dataTypeVersion;
	}
	public byte[] getDictionaryFragment() {
		return dictionaryFragment;
	}
	public void setDictionaryFragment(byte[] dictionaryFragment) {
		this.dictionaryFragment = dictionaryFragment;
	}
	public boolean isAllowNulls() {
		return allowNulls;
	}
	public void setAllowNulls(boolean allowNulls) {
		this.allowNulls = allowNulls;
	}
}
