package opc.ua.addressspace.nodeclasse;

import opc.ua.addressspace.datatype.NodeId;

public class VariableTypeNode extends BaseNode {

	/**
	 * attributes
	 */
	/**
	 * defined by dataType
	 */
	private Object value;
	
	private NodeId dataType;
	private int valueRank;
	private long[] arrayDimensions;
	private boolean isAbstract;
	
	/**
	 * references
	 */
	/** 
	 * OPC UA Part 3, p.43
	 */
	private BaseNode[] hasProperty;
	private BaseNode[] hasComponent;
	private BaseNode[] hasSubtype;
	private BaseNode[] generatesEvent;
	// other references
	
	/**
	 * properties
	 */
	private String nodeVersion;

	public Object getValue() {
		return value;
	}

	public void setValue(Object value) {
		this.value = value;
	}

	public NodeId getDataType() {
		return dataType;
	}

	public void setDataType(NodeId dataType) {
		this.dataType = dataType;
	}
	
	public void setDataType(String identifier) {
		this.dataType = new NodeId(identifier);
	}

	public int getValueRank() {
		return valueRank;
	}

	public void setValueRank(int valueRank) {
		this.valueRank = valueRank;
	}

	public long[] getArrayDimensions() {
		return arrayDimensions;
	}

	public void setArrayDimensions(long[] arrayDimensions) {
		this.arrayDimensions = arrayDimensions;
	}

	public boolean isAbstract() {
		return isAbstract;
	}

	public void setAbstract(boolean isAbstract) {
		this.isAbstract = isAbstract;
	}

	public BaseNode[] getHasProperty() {
		return hasProperty;
	}

	public void setHasProperty(BaseNode[] hasProperty) {
		this.hasProperty = hasProperty;
	}

	public BaseNode[] getHasComponent() {
		return hasComponent;
	}

	public void setHasComponent(BaseNode[] hasComponent) {
		this.hasComponent = hasComponent;
	}

	public BaseNode[] getHasSubtype() {
		return hasSubtype;
	}

	public void setHasSubtype(BaseNode[] hasSubtype) {
		this.hasSubtype = hasSubtype;
	}

	public BaseNode[] getGeneratesEvent() {
		return generatesEvent;
	}

	public void setGeneratesEvent(BaseNode[] generatesEvent) {
		this.generatesEvent = generatesEvent;
	}

	public String getNodeVersion() {
		return nodeVersion;
	}

	public void setNodeVersion(String nodeVersion) {
		this.nodeVersion = nodeVersion;
	}	
}
