package opc.ua.addressspace.nodeclasse;

public class ViewNode extends BaseNode {

	/**
	 * attributes
	 */
	private boolean containsNoLoops;
	
	/**
	    The EventNotifier Attribute is used to indicate if the Node can be used to
	    subscribe to Events or to read / write historic Events.
		
		Field        Bit Description
		SubscribeTo  0   Indicates if it can be used to subscribe to Events
		Events           (0 means cannot be used to subscribe to Events,
		                 1 means can be used to subscribe to Events).
		Reserved     1   Reserved for future use. Shall always be zero.
		HistoryRead  2   Indicates if the history of the Events is readable
		                 (0 means not readable, 1 means readable).
		HistoryWrite 3   Indicates if the history of the Events is writable
		                 (0 means not writable, 1 means writable).
		Reserved     4:7 Reserved for future use. Shall always be zero.
	*/
	private byte eventNotifier;
	
	/**
	 * references
	 */
	/** 
	 * OPC UA PART 3 - p.31
	 */
	private BaseNode[] hierarchicalReferences;
	private BaseNode[] hasProperty;

	/**
	 * properties
	 */
	private String nodeVersion;
	private long viewVersion;
	
	
	public boolean isContainsNoLoops() {
		return containsNoLoops;
	}
	public void setContainsNoLoops(boolean containsNoLoops) {
		this.containsNoLoops = containsNoLoops;
	}
	public byte getEventNotifier() {
		return eventNotifier;
	}
	public void setEventNotifier(byte eventNotifier) {
		this.eventNotifier = eventNotifier;
	}
	public BaseNode[] getHierarchicalReferences() {
		return hierarchicalReferences;
	}
	public void setHierarchicalReferences(BaseNode[] hierarchicalReferences) {
		this.hierarchicalReferences = hierarchicalReferences;
	}
	public BaseNode[] getHasProperty() {
		return hasProperty;
	}
	public void setHasProperty(BaseNode[] hasProperty) {
		this.hasProperty = hasProperty;
	}
	public String getNodeVersion() {
		return nodeVersion;
	}
	public void setNodeVersion(String nodeVersion) {
		this.nodeVersion = nodeVersion;
	}
	public long getViewVersion() {
		return viewVersion;
	}
	public void setViewVersion(long viewVersion) {
		this.viewVersion = viewVersion;
	}
}
