package opc.ua.im.datatype;

import opc.ua.addressspace.datatype.NodeId;
import opc.ua.addressspace.nodeclasse.DataTypeNode;

public class ModelChangeStructureDataType extends DataTypeNode {
	
	private NodeId affected;
	private NodeId affectedType;
	
	/**
	 * NodeAdded        0   Indicates the affected Node has been added.
	 * NodeDeleted      1   Indicates the affected Node has been deleted.
	 * ReferenceAdded   2   Indicates a Reference has been added. The
     *                affected Node may be either a SourceNode or
     *                TargetNode. Note that an added bidirectional
     *                Reference is reflected by two ChangeStructures.
	 * ReferenceDeleted 3   Indicates a Reference has been deleted. The
     *                affected Node may be either a SourceNode or
     *                TargetNode. Note that a deleted bidirectional
     *                Reference is reflected by two ChangeStructures.
     * DataTypeChanged  4   This verb may be used only for affected Nodes
     *                that are Variables or VariableTypes. It indicates
     *                that the DataType Attribute has changed.
	 * Reserved         5:7 Reserved for future use. Shall always be zero.
	 */
	private byte verb;

	
	public ModelChangeStructureDataType() {
		setBrowseName("ModelChangeStructureDataType");
	}
	
	public NodeId getAffected() {
		return affected;
	}

	public void setAffected(NodeId affected) {
		this.affected = affected;
	}

	public NodeId getAffectedType() {
		return affectedType;
	}

	public void setAffectedType(NodeId affectedType) {
		this.affectedType = affectedType;
	}

	public byte getVerb() {
		return verb;
	}

	public void setVerb(byte verb) {
		this.verb = verb;
	}

}
