package opc.ua.im.datatype;

import opc.ua.addressspace.nodeclasse.DataTypeNode;

public class RedundancySupport extends DataTypeNode {
	
	/**
	 * NONE_0        None means that there is no redundancy support.
	 * COLD_1        Cold means that the redundant servers are operational, but do not have any subscriptions defined and do
     *         not accept requests to create one.
	 * WARM_2        Warm means that the redundant servers have redundant subscriptions, but with sampling disabled.
	 * HOT_3         Hot means that the redundant servers have redundant subscriptions with sampling enabled, but not
     *         reporting.
	 * TRANSPARENT_4 Transparent means that the server supports transparent redundancy as defined in Part 1.
	 */
	
	public RedundancySupport() {
		setBrowseName("RedundancySupport");
	}

}
