package opc.ua.im.datatype;

import opc.ua.addressspace.nodeclasse.DataTypeNode;

public class ServerState extends DataTypeNode {
	
	/**
	 * RUNNING_0             The server is running normally. This is the usual state for a server.
	 * FAILED_1              A vendor-specific fatal error has occurred within the server. The server is no longer functioning.
     *                 The recovery procedure from this situation is vendor-specific. Most Service requests should be
     *                 expected to fail.
	 * NO_CONFIGURATION_2    The server is running but has no configuration information loaded and therefore does not transfer
     *                 data.
	 * SUSPENDED_3           The server has been temporarily suspended by some vendor-specific method and is not receiving
     *                 or sending data.
	 * SHUTDOWN_4            The server has shut down or is in the process of shutting down. Depending on the implementation,
     *                 this might or might not be visible to clients.
	 * TEST_5                The server is in Test Mode. The outputs are disconnected from the real hardware, but the server
     *                 will otherwise behave normally. Inputs may be real or may be simulated depending on the vendor
     *                 implementation. StatusCode will generally be returned normally.
	 * COMMUNICATION_FAULT_6 The server is running properly, but is having difficulty accessing data from its data sources. This
     *                 may be due to communication problems or some other problem preventing the underlying device,
     *                 control system, etc. from returning valid data. It may be a complete failure, meaning that no data is
     *                 available, or a partial failure, meaning that some data is still available. It is expected that items
     *                 affected by the fault will individually return with a BAD FAILURE status code indication for the
     *                 items.
	 * UNKNOWN_7             This state is used only to indicate that the OPC UA server does not know the state of underlying
     *                 servers.
	 */
	
	public ServerState() {
		setBrowseName("ServerState");
	}

}
