package opc.ua.im.datatype;

import java.util.Date;

import opc.ua.addressspace.datatype.LocalizedText;
import opc.ua.addressspace.nodeclasse.DataTypeNode;

public class ServerStatusDataType extends DataTypeNode {
	
	/** UtcTime */
	private Date startTime;
	private Date currentTime;
	private ServerState state;
	private BuildInfo buildInfo;
	private long secondsTillShutdown;
	private LocalizedText shutdownReason;

	
	public ServerStatusDataType() {
		setBrowseName("ServerStatusDataType");
	}
	
	public Date getStartTime() {
		return startTime;
	}
	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}
	public Date getCurrentTime() {
		return currentTime;
	}
	public void setCurrentTime(Date currentTime) {
		this.currentTime = currentTime;
	}
	public ServerState getState() {
		return state;
	}
	public void setState(ServerState state) {
		this.state = state;
	}
	public BuildInfo getBuildInfo() {
		return buildInfo;
	}
	public void setBuildInfo(BuildInfo buildInfo) {
		this.buildInfo = buildInfo;
	}
	public long getSecondsTillShutdown() {
		return secondsTillShutdown;
	}
	public void setSecondsTillShutdown(long secondsTillShutdown) {
		this.secondsTillShutdown = secondsTillShutdown;
	}
	public LocalizedText getShutdownReason() {
		return shutdownReason;
	}
	public void setShutdownReason(LocalizedText shutdownReason) {
		this.shutdownReason = shutdownReason;
	}
	
}
