package opc.ua.im.datatype;

import java.util.Date;

import opc.ua.addressspace.datatype.LocaleId;
import opc.ua.addressspace.datatype.NodeId;
import opc.ua.addressspace.nodeclasse.DataTypeNode;
import opc.ua.services.common.ApplicationDescription;
import opc.ua.services.common.Counter;

public class SessionDiagnosticsDataType extends DataTypeNode {
	
	private NodeId sessionId;
	private String sessionName;
	private ApplicationDescription clientDesription;
	private String serverUri;
	private String endpointUrl;
	private LocaleId[] localeIds;
	/** Duration */
	private long actualSessionTimeout;
	private long maxResponseMessageSize;
	/** UtcTime */
	private Date clientConnectionTime;
	private Date clientLastContactTime;
	private long currentSubscriptionsCount;
	private long currentMonitoredItemsCount;
	private long currentPublishRequestsInQueue;
	private long currentPublishTimerExpirations;
	
	/** ServiceCounter DataType */
	private Counter totalRequestsCount;
	private long unauthorizedRequestsCount;
	private Counter readCount;
	private Counter historyReadCount;
	private Counter writeCount;
	private Counter historyUpdateCount;
	private Counter callCount;
	private Counter createMonitoredItemsCount;
	private Counter modifyMonitoredItemsCount;
	private Counter setMonitoringModeCount;
	private Counter setTriggeringCount;
	private Counter deleteMonitoredItemsCount;
	private Counter createSubscriptionCount;
	private Counter modifySubscriptionCount;
	private Counter setPublishingModeCount;
	private Counter publishCount;
	private Counter republishCount;
	private Counter transferSubscriptionsCount;
	private Counter deleteSubscriptionsCount;
	private Counter addNodesCount;
	private Counter addReferencesCount;
	private Counter deleteNodesCount;
	private Counter deleteReferencesCount;
	private Counter browseCount;
	private Counter browseNextCount;
	private Counter translateBrowsePathsToNodeIdsCount;
	private Counter queryFirstCount;
	private Counter queryNextCount;
	private Counter registerNodesCount;
	private Counter unregisterNodesCount;
	
	
	public SessionDiagnosticsDataType() {
		setBrowseName("SessionDiagnosticsDataType");
	}
	
	public NodeId getSessionId() {
		return sessionId;
	}
	public void setSessionId(NodeId sessionId) {
		this.sessionId = sessionId;
	}
	public String getSessionName() {
		return sessionName;
	}
	public void setSessionName(String sessionName) {
		this.sessionName = sessionName;
	}
	public ApplicationDescription getClientDesription() {
		return clientDesription;
	}
	public void setClientDesription(ApplicationDescription clientDesription) {
		this.clientDesription = clientDesription;
	}
	public String getServerUri() {
		return serverUri;
	}
	public void setServerUri(String serverUri) {
		this.serverUri = serverUri;
	}
	public String getEndpointUrl() {
		return endpointUrl;
	}
	public void setEndpointUrl(String endpointUrl) {
		this.endpointUrl = endpointUrl;
	}
	public LocaleId[] getLocaleIds() {
		return localeIds;
	}
	public void setLocaleIds(LocaleId[] localeIds) {
		this.localeIds = localeIds;
	}
	public long getActualSessionTimeout() {
		return actualSessionTimeout;
	}
	public void setActualSessionTimeout(long actualSessionTimeout) {
		this.actualSessionTimeout = actualSessionTimeout;
	}
	public long getMaxResponseMessageSize() {
		return maxResponseMessageSize;
	}
	public void setMaxResponseMessageSize(long maxResponseMessageSize) {
		this.maxResponseMessageSize = maxResponseMessageSize;
	}
	public Date getClientConnectionTime() {
		return clientConnectionTime;
	}
	public void setClientConnectionTime(Date clientConnectionTime) {
		this.clientConnectionTime = clientConnectionTime;
	}
	public Date getClientLastContactTime() {
		return clientLastContactTime;
	}
	public void setClientLastContactTime(Date clientLastContactTime) {
		this.clientLastContactTime = clientLastContactTime;
	}
	public long getCurrentSubscriptionsCount() {
		return currentSubscriptionsCount;
	}
	public void setCurrentSubscriptionsCount(long currentSubscriptionsCount) {
		this.currentSubscriptionsCount = currentSubscriptionsCount;
	}
	public long getCurrentMonitoredItemsCount() {
		return currentMonitoredItemsCount;
	}
	public void setCurrentMonitoredItemsCount(long currentMonitoredItemsCount) {
		this.currentMonitoredItemsCount = currentMonitoredItemsCount;
	}
	public long getCurrentPublishRequestsInQueue() {
		return currentPublishRequestsInQueue;
	}
	public void setCurrentPublishRequestsInQueue(long currentPublishRequestsInQueue) {
		this.currentPublishRequestsInQueue = currentPublishRequestsInQueue;
	}
	public long getCurrentPublishTimerExpirations() {
		return currentPublishTimerExpirations;
	}
	public void setCurrentPublishTimerExpirations(
			long currentPublishTimerExpirations) {
		this.currentPublishTimerExpirations = currentPublishTimerExpirations;
	}
	public Counter getTotalRequestsCount() {
		return totalRequestsCount;
	}
	public void setTotalRequestsCount(Counter totalRequestsCount) {
		this.totalRequestsCount = totalRequestsCount;
	}
	public long getUnauthorizedRequestsCount() {
		return unauthorizedRequestsCount;
	}
	public void setUnauthorizedRequestsCount(long unauthorizedRequestsCount) {
		this.unauthorizedRequestsCount = unauthorizedRequestsCount;
	}
	public Counter getReadCount() {
		return readCount;
	}
	public void setReadCount(Counter readCount) {
		this.readCount = readCount;
	}
	public Counter getHistoryReadCount() {
		return historyReadCount;
	}
	public void setHistoryReadCount(Counter historyReadCount) {
		this.historyReadCount = historyReadCount;
	}
	public Counter getWriteCount() {
		return writeCount;
	}
	public void setWriteCount(Counter writeCount) {
		this.writeCount = writeCount;
	}
	public Counter getHistoryUpdateCount() {
		return historyUpdateCount;
	}
	public void setHistoryUpdateCount(Counter historyUpdateCount) {
		this.historyUpdateCount = historyUpdateCount;
	}
	public Counter getCallCount() {
		return callCount;
	}
	public void setCallCount(Counter callCount) {
		this.callCount = callCount;
	}
	public Counter getCreateMonitoredItemsCount() {
		return createMonitoredItemsCount;
	}
	public void setCreateMonitoredItemsCount(Counter createMonitoredItemsCount) {
		this.createMonitoredItemsCount = createMonitoredItemsCount;
	}
	public Counter getModifyMonitoredItemsCount() {
		return modifyMonitoredItemsCount;
	}
	public void setModifyMonitoredItemsCount(Counter modifyMonitoredItemsCount) {
		this.modifyMonitoredItemsCount = modifyMonitoredItemsCount;
	}
	public Counter getSetMonitoringModeCount() {
		return setMonitoringModeCount;
	}
	public void setSetMonitoringModeCount(Counter setMonitoringModeCount) {
		this.setMonitoringModeCount = setMonitoringModeCount;
	}
	public Counter getSetTriggeringCount() {
		return setTriggeringCount;
	}
	public void setSetTriggeringCount(Counter setTriggeringCount) {
		this.setTriggeringCount = setTriggeringCount;
	}
	public Counter getDeleteMonitoredItemsCount() {
		return deleteMonitoredItemsCount;
	}
	public void setDeleteMonitoredItemsCount(Counter deleteMonitoredItemsCount) {
		this.deleteMonitoredItemsCount = deleteMonitoredItemsCount;
	}
	public Counter getCreateSubscriptionCount() {
		return createSubscriptionCount;
	}
	public void setCreateSubscriptionCount(Counter createSubscriptionCount) {
		this.createSubscriptionCount = createSubscriptionCount;
	}
	public Counter getModifySubscriptionCount() {
		return modifySubscriptionCount;
	}
	public void setModifySubscriptionCount(Counter modifySubscriptionCount) {
		this.modifySubscriptionCount = modifySubscriptionCount;
	}
	public Counter getSetPublishingModeCount() {
		return setPublishingModeCount;
	}
	public void setSetPublishingModeCount(Counter setPublishingModeCount) {
		this.setPublishingModeCount = setPublishingModeCount;
	}
	public Counter getPublishCount() {
		return publishCount;
	}
	public void setPublishCount(Counter publishCount) {
		this.publishCount = publishCount;
	}
	public Counter getRepublishCount() {
		return republishCount;
	}
	public void setRepublishCount(Counter republishCount) {
		this.republishCount = republishCount;
	}
	public Counter getTransferSubscriptionsCount() {
		return transferSubscriptionsCount;
	}
	public void setTransferSubscriptionsCount(Counter transferSubscriptionsCount) {
		this.transferSubscriptionsCount = transferSubscriptionsCount;
	}
	public Counter getDeleteSubscriptionsCount() {
		return deleteSubscriptionsCount;
	}
	public void setDeleteSubscriptionsCount(Counter deleteSubscriptionsCount) {
		this.deleteSubscriptionsCount = deleteSubscriptionsCount;
	}
	public Counter getAddNodesCount() {
		return addNodesCount;
	}
	public void setAddNodesCount(Counter addNodesCount) {
		this.addNodesCount = addNodesCount;
	}
	public Counter getAddReferencesCount() {
		return addReferencesCount;
	}
	public void setAddReferencesCount(Counter addReferencesCount) {
		this.addReferencesCount = addReferencesCount;
	}
	public Counter getDeleteNodesCount() {
		return deleteNodesCount;
	}
	public void setDeleteNodesCount(Counter deleteNodesCount) {
		this.deleteNodesCount = deleteNodesCount;
	}
	public Counter getDeleteReferencesCount() {
		return deleteReferencesCount;
	}
	public void setDeleteReferencesCount(Counter deleteReferencesCount) {
		this.deleteReferencesCount = deleteReferencesCount;
	}
	public Counter getBrowseCount() {
		return browseCount;
	}
	public void setBrowseCount(Counter browseCount) {
		this.browseCount = browseCount;
	}
	public Counter getBrowseNextCount() {
		return browseNextCount;
	}
	public void setBrowseNextCount(Counter browseNextCount) {
		this.browseNextCount = browseNextCount;
	}
	public Counter getTranslateBrowsePathsToNodeIdsCount() {
		return translateBrowsePathsToNodeIdsCount;
	}
	public void setTranslateBrowsePathsToNodeIdsCount(
			Counter translateBrowsePathsToNodeIdsCount) {
		this.translateBrowsePathsToNodeIdsCount = translateBrowsePathsToNodeIdsCount;
	}
	public Counter getQueryFirstCount() {
		return queryFirstCount;
	}
	public void setQueryFirstCount(Counter queryFirstCount) {
		this.queryFirstCount = queryFirstCount;
	}
	public Counter getQueryNextCount() {
		return queryNextCount;
	}
	public void setQueryNextCount(Counter queryNextCount) {
		this.queryNextCount = queryNextCount;
	}
	public Counter getRegisterNodesCount() {
		return registerNodesCount;
	}
	public void setRegisterNodesCount(Counter registerNodesCount) {
		this.registerNodesCount = registerNodesCount;
	}
	public Counter getUnregisterNodesCount() {
		return unregisterNodesCount;
	}
	public void setUnregisterNodesCount(Counter unregisterNodesCount) {
		this.unregisterNodesCount = unregisterNodesCount;
	}

}
