package opc.ua.services.common;

import opc.ua.addressspace.datatype.LocalizedText;

public class ApplicationDescription {

	private String applicationUri;
	private String productUri;
	private LocalizedText applicationName;
	
	/**
	 * SERVER_0          The application is a Server.
	 * CLIENT_1          The application is a Client.
	 * CLIENTANDSERVER_2 The application is a Client and a Server.
	 * DISCOVERYSERVER_3 The application is a DiscoveryServer.
	 */
	private String applicationType;
	
	private String gatewayServerUri;
	private String discoveryProfileUri;
	private String[] discoveryUrls;
	
	public String getApplicationUri() {
		return applicationUri;
	}
	public void setApplicationUri(String applicationUri) {
		this.applicationUri = applicationUri;
	}
	public String getProductUri() {
		return productUri;
	}
	public void setProductUri(String productUri) {
		this.productUri = productUri;
	}
	public LocalizedText getApplicationName() {
		return applicationName;
	}
	public void setApplicationName(LocalizedText applicationName) {
		this.applicationName = applicationName;
	}
	public String getApplicationType() {
		return applicationType;
	}
	public void setApplicationType(String applicationType) {
		this.applicationType = applicationType;
	}
	public String getGatewayServerUri() {
		return gatewayServerUri;
	}
	public void setGatewayServerUri(String gatewayServerUri) {
		this.gatewayServerUri = gatewayServerUri;
	}
	public String getDiscoveryProfileUri() {
		return discoveryProfileUri;
	}
	public void setDiscoveryProfileUri(String discoveryProfileUri) {
		this.discoveryProfileUri = discoveryProfileUri;
	}
	public String[] getDiscoveryUrls() {
		return discoveryUrls;
	}
	public void setDiscoveryUrls(String[] discoveryUrls) {
		this.discoveryUrls = discoveryUrls;
	}
	
}
