package opc.ua.services.common;

import java.util.Date;

public class SignedSoftwareCertificate {

	private String version;
	private byte[] serialNumber;
	private String signatureAlgorithm;
	private byte[] signature;
	
	/** A name that identifies the Issuer Certificate used to create the signature. */
	private String issuer;
	private Date validFrom;
	private Date validTo;
	
	/**
	 * A name that identifies the product which the Certificate describes.
	 * This field shall contain the productName and vendorName from the
	 * SoftwareCertificate.
	 */
	private String subject;
	
	/** 
	 * A list of alternate names for the product.
	 * This list shall include the productUri specified in the SoftwareCertificate.
	 */
	private String[] subjectAltName;
	
	private byte[] publicKey;
	private String[] keyUsage;
	private byte[] softwareCertificate;
	
	
	public String getVersion() {
		return version;
	}
	public void setVersion(String version) {
		this.version = version;
	}
	public byte[] getSerialNumber() {
		return serialNumber;
	}
	public void setSerialNumber(byte[] serialNumber) {
		this.serialNumber = serialNumber;
	}
	public String getSignatureAlgorithm() {
		return signatureAlgorithm;
	}
	public void setSignatureAlgorithm(String signatureAlgorithm) {
		this.signatureAlgorithm = signatureAlgorithm;
	}
	public byte[] getSignature() {
		return signature;
	}
	public void setSignature(byte[] signature) {
		this.signature = signature;
	}
	public String getIssuer() {
		return issuer;
	}
	public void setIssuer(String issuer) {
		this.issuer = issuer;
	}
	public Date getValidFrom() {
		return validFrom;
	}
	public void setValidFrom(Date validFrom) {
		this.validFrom = validFrom;
	}
	public Date getValidTo() {
		return validTo;
	}
	public void setValidTo(Date validTo) {
		this.validTo = validTo;
	}
	public String getSubject() {
		return subject;
	}
	public void setSubject(String subject) {
		this.subject = subject;
	}
	public String[] getSubjectAltName() {
		return subjectAltName;
	}
	public void setSubjectAltName(String[] subjectAltName) {
		this.subjectAltName = subjectAltName;
	}
	public byte[] getPublicKey() {
		return publicKey;
	}
	public void setPublicKey(byte[] publicKey) {
		this.publicKey = publicKey;
	}
	public String[] getKeyUsage() {
		return keyUsage;
	}
	public void setKeyUsage(String[] keyUsage) {
		this.keyUsage = keyUsage;
	}
	public byte[] getSoftwareCertificate() {
		return softwareCertificate;
	}
	public void setSoftwareCertificate(byte[] softwareCertificate) {
		this.softwareCertificate = softwareCertificate;
	}
	
}
