package opc.ua.services.common;

import java.util.Date;

public class SoftwareCertificate {

	private String productName;
	private String productUri;
	private String vendorName;
	private byte[] vendorProductCertificate;
	private String softwareVersion;
	private String buildNumber;
	private Date buildDate;
	private String issuedBy;
	private Date issueDate;
	private Profile supportedProfiles;

	private class Profile {
		private String organizationUri;
		private String profileId;
		private String complianceTool;
		private Date complianceDate;
		
		/** 
		 * UNTESTED_0 the profiled capability has not been tested successfully
		 * PARTIAL_1    the profiled capability has been partially tested and has
         *    passed critical tests, as defined by the certifying authority.
		 * SELFTESTED_2 the profiled capability has been successfully tested using a
         *    self-test system authorized by the certifying authority.
		 * CERTIFIED_3  the profiled capability has been successfully tested by a
         *    testing organisation authorized by the certifying authority.
         */
		private String complianceLevel;
		
		private String[] unsupportedUnitIds;
		
	}


	public String getProductName() {
		return productName;
	}

	public void setProductName(String productName) {
		this.productName = productName;
	}

	public String getProductUri() {
		return productUri;
	}

	public void setProductUri(String productUri) {
		this.productUri = productUri;
	}

	public String getVendorName() {
		return vendorName;
	}

	public void setVendorName(String vendorName) {
		this.vendorName = vendorName;
	}

	public byte[] getVendorProductCertificate() {
		return vendorProductCertificate;
	}

	public void setVendorProductCertificate(byte[] vendorProductCertificate) {
		this.vendorProductCertificate = vendorProductCertificate;
	}

	public String getSoftwareVersion() {
		return softwareVersion;
	}

	public void setSoftwareVersion(String softwareVersion) {
		this.softwareVersion = softwareVersion;
	}

	public String getBuildNumber() {
		return buildNumber;
	}

	public void setBuildNumber(String buildNumber) {
		this.buildNumber = buildNumber;
	}

	public Date getBuildDate() {
		return buildDate;
	}

	public void setBuildDate(Date buildDate) {
		this.buildDate = buildDate;
	}

	public String getIssuedBy() {
		return issuedBy;
	}

	public void setIssuedBy(String issuedBy) {
		this.issuedBy = issuedBy;
	}

	public Date getIssueDate() {
		return issueDate;
	}

	public void setIssueDate(Date issueDate) {
		this.issueDate = issueDate;
	}

	public Profile getSupportedProfiles() {
		return supportedProfiles;
	}

	public void setSupportedProfiles(Profile supportedProfiles) {
		this.supportedProfiles = supportedProfiles;
	}
	
}
