package opc.ua.services.sets;

import opc.ua.addressspace.datatype.LocaleId;
import opc.ua.services.common.DiagnosticInfo;
import opc.ua.services.common.RequestHeader;
import opc.ua.services.common.ResponseHeader;
import opc.ua.services.common.SignatureData;
import opc.ua.services.common.SignedSoftwareCertificate;
import opc.ua.services.common.StatusCode;
import opc.ua.services.common.UserIdentityTokenType;

public class ActivateSession {

	/**
	 * request
	 */
	private RequestHeader requestHeader;
	private SignatureData clientSignature;
	private SignedSoftwareCertificate[] clienSoftwareCertificates;
	private LocaleId[] localeIds;
	private UserIdentityTokenType userIdentityToken;
	private SignatureData userTokenSignature;

	/**
	 * response
	 */
	private ResponseHeader responseHeader;
	private byte[] serverNonce;
	private StatusCode[] results;
	private DiagnosticInfo[] diagnosticInfos;
	
	public RequestHeader getRequestHeader() {
		return requestHeader;
	}
	public void setRequestHeader(RequestHeader requestHeader) {
		this.requestHeader = requestHeader;
	}
	public SignatureData getClientSignature() {
		return clientSignature;
	}
	public void setClientSignature(SignatureData clientSignature) {
		this.clientSignature = clientSignature;
	}
	public SignedSoftwareCertificate[] getClienSoftwareCertificates() {
		return clienSoftwareCertificates;
	}
	public void setClienSoftwareCertificates(
			SignedSoftwareCertificate[] clienSoftwareCertificates) {
		this.clienSoftwareCertificates = clienSoftwareCertificates;
	}
	public LocaleId[] getLocaleIds() {
		return localeIds;
	}
	public void setLocaleIds(LocaleId[] localeIds) {
		this.localeIds = localeIds;
	}
	public UserIdentityTokenType getUserIdentityToken() {
		return userIdentityToken;
	}
	public void setUserIdentityToken(UserIdentityTokenType userIdentityToken) {
		this.userIdentityToken = userIdentityToken;
	}
	public SignatureData getUserTokenSignature() {
		return userTokenSignature;
	}
	public void setUserTokenSignature(SignatureData userTokenSignature) {
		this.userTokenSignature = userTokenSignature;
	}
	public ResponseHeader getResponseHeader() {
		return responseHeader;
	}
	public void setResponseHeader(ResponseHeader responseHeader) {
		this.responseHeader = responseHeader;
	}
	public byte[] getServerNonce() {
		return serverNonce;
	}
	public void setServerNonce(byte[] serverNonce) {
		this.serverNonce = serverNonce;
	}
	public StatusCode[] getResults() {
		return results;
	}
	public void setResults(StatusCode[] results) {
		this.results = results;
	}
	public DiagnosticInfo[] getDiagnosticInfos() {
		return diagnosticInfos;
	}
	public void setDiagnosticInfos(DiagnosticInfo[] diagnosticInfos) {
		this.diagnosticInfos = diagnosticInfos;
	}
	
}
