package opc.ua.services.sets;

import opc.ua.addressspace.datatype.NodeId;
import opc.ua.addressspace.datatype.QualifiedName;
import opc.ua.addressspace.nodeclasse.BaseNode;
import opc.ua.services.common.DiagnosticInfo;
import opc.ua.services.common.ExpandedNodeId;
import opc.ua.services.common.NodeAttributes;
import opc.ua.services.common.RequestHeader;
import opc.ua.services.common.ResponseHeader;
import opc.ua.services.common.StatusCode;

public class AddNodes {

	/** 
	 * request
	 */
	private RequestHeader requestHeader;
	private AddNodesItem[] nodesToAdd;
	
	/**
	 * response
	 */
	private ResponseHeader responseHeader;
	private AddNodesResult[] results;
	private DiagnosticInfo[] diagnosticInfos;
	
	
	private class AddNodesItem {
		private ExpandedNodeId parentNodeId;
		private NodeId referenceTypeId;
		private ExpandedNodeId requestedNewNodeId;
		private QualifiedName browseName;
		private BaseNode nodeClass;
		private NodeAttributes nodeAttributes;
		private ExpandedNodeId typeDefinition;
		
		public ExpandedNodeId getParentNodeId() {
			return parentNodeId;
		}
		public void setParentNodeId(ExpandedNodeId parentNodeId) {
			this.parentNodeId = parentNodeId;
		}
		public NodeId getReferenceTypeId() {
			return referenceTypeId;
		}
		public void setReferenceTypeId(NodeId referenceTypeId) {
			this.referenceTypeId = referenceTypeId;
		}
		public ExpandedNodeId getRequestedNewNodeId() {
			return requestedNewNodeId;
		}
		public void setRequestedNewNodeId(ExpandedNodeId requestedNewNodeId) {
			this.requestedNewNodeId = requestedNewNodeId;
		}
		public QualifiedName getBrowseName() {
			return browseName;
		}
		public void setBrowseName(QualifiedName browseName) {
			this.browseName = browseName;
		}
		public BaseNode getNodeClass() {
			return nodeClass;
		}
		public void setNodeClass(BaseNode nodeClass) {
			this.nodeClass = nodeClass;
		}
		public NodeAttributes getNodeAttributes() {
			return nodeAttributes;
		}
		public void setNodeAttributes(NodeAttributes nodeAttributes) {
			this.nodeAttributes = nodeAttributes;
		}
		public ExpandedNodeId getTypeDefinition() {
			return typeDefinition;
		}
		public void setTypeDefinition(ExpandedNodeId typeDefinition) {
			this.typeDefinition = typeDefinition;
		}
		
	}
	
	private class AddNodesResult {
		private StatusCode statusCode;
		private NodeId addedNodeId;
		
		public StatusCode getStatusCode() {
			return statusCode;
		}
		public void setStatusCode(StatusCode statusCode) {
			this.statusCode = statusCode;
		}
		public NodeId getAddedNodeId() {
			return addedNodeId;
		}
		public void setAddedNodeId(NodeId addedNodeId) {
			this.addedNodeId = addedNodeId;
		}
		
	}

	public RequestHeader getRequestHeader() {
		return requestHeader;
	}

	public void setRequestHeader(RequestHeader requestHeader) {
		this.requestHeader = requestHeader;
	}

	public AddNodesItem[] getNodesToAdd() {
		return nodesToAdd;
	}

	public void setNodesToAdd(AddNodesItem[] nodesToAdd) {
		this.nodesToAdd = nodesToAdd;
	}

	public ResponseHeader getResponseHeader() {
		return responseHeader;
	}

	public void setResponseHeader(ResponseHeader responseHeader) {
		this.responseHeader = responseHeader;
	}

	public AddNodesResult[] getResults() {
		return results;
	}

	public void setResults(AddNodesResult[] results) {
		this.results = results;
	}

	public DiagnosticInfo[] getDiagnosticInfos() {
		return diagnosticInfos;
	}

	public void setDiagnosticInfos(DiagnosticInfo[] diagnosticInfos) {
		this.diagnosticInfos = diagnosticInfos;
	}
	
}
