package opc.ua.services.sets;

import opc.ua.addressspace.datatype.NodeId;
import opc.ua.addressspace.nodeclasse.BaseNode;
import opc.ua.services.common.DiagnosticInfo;
import opc.ua.services.common.ExpandedNodeId;
import opc.ua.services.common.RequestHeader;
import opc.ua.services.common.ResponseHeader;
import opc.ua.services.common.StatusCode;

public class AddReferences {

	/**
	 * request
	 */
	private RequestHeader requestHeader;
	private AddReferencesItem[] referencesToAdd;
	
	/**
	 * response
	 */
	private ResponseHeader responseHeader;
	private StatusCode[] results;
	private DiagnosticInfo[] diagnosticInfos;
	
	private class AddReferencesItem {
		private NodeId sourceNodeId;
		private NodeId referenceTypeId;
		private boolean isForward;
		private String targetServerUri;
		private ExpandedNodeId targetNodeId;
		private BaseNode targetNodeClass;
		
		public NodeId getSourceNodeId() {
			return sourceNodeId;
		}
		public void setSourceNodeId(NodeId sourceNodeId) {
			this.sourceNodeId = sourceNodeId;
		}
		public NodeId getReferenceTypeId() {
			return referenceTypeId;
		}
		public void setReferenceTypeId(NodeId referenceTypeId) {
			this.referenceTypeId = referenceTypeId;
		}
		public boolean isForward() {
			return isForward;
		}
		public void setForward(boolean isForward) {
			this.isForward = isForward;
		}
		public String getTargetServerUri() {
			return targetServerUri;
		}
		public void setTargetServerUri(String targetServerUri) {
			this.targetServerUri = targetServerUri;
		}
		public ExpandedNodeId getTargetNodeId() {
			return targetNodeId;
		}
		public void setTargetNodeId(ExpandedNodeId targetNodeId) {
			this.targetNodeId = targetNodeId;
		}
		public BaseNode getTargetNodeClass() {
			return targetNodeClass;
		}
		public void setTargetNodeClass(BaseNode targetNodeClass) {
			this.targetNodeClass = targetNodeClass;
		}
		
	}

	public RequestHeader getRequestHeader() {
		return requestHeader;
	}

	public void setRequestHeader(RequestHeader requestHeader) {
		this.requestHeader = requestHeader;
	}

	public AddReferencesItem[] getReferencesToAdd() {
		return referencesToAdd;
	}

	public void setReferencesToAdd(AddReferencesItem[] referencesToAdd) {
		this.referencesToAdd = referencesToAdd;
	}

	public ResponseHeader getResponseHeader() {
		return responseHeader;
	}

	public void setResponseHeader(ResponseHeader responseHeader) {
		this.responseHeader = responseHeader;
	}

	public StatusCode[] getResults() {
		return results;
	}

	public void setResults(StatusCode[] results) {
		this.results = results;
	}

	public DiagnosticInfo[] getDiagnosticInfos() {
		return diagnosticInfos;
	}

	public void setDiagnosticInfos(DiagnosticInfo[] diagnosticInfos) {
		this.diagnosticInfos = diagnosticInfos;
	}
	
}
