package opc.ua.services.sets;

import opc.ua.addressspace.datatype.NodeId;
import opc.ua.services.common.BrowseResult;
import opc.ua.services.common.Counter;
import opc.ua.services.common.DiagnosticInfo;
import opc.ua.services.common.RequestHeader;
import opc.ua.services.common.ResponseHeader;
import opc.ua.services.common.ViewDescription;

public class Browse {

	/** 
	 * request
	 */
	private RequestHeader requestHeader;
	private ViewDescription view;
	private Counter requestedMaxReferencesPerNode;
	private BrowseDescription[] nodesToBrowse;
	
	/**
	 * response
	 */
	private ResponseHeader responseHeader;
	private BrowseResult[] results;
	private DiagnosticInfo[] diagnosticInfos;
	
	private class BrowseDescription {
		private NodeId nodeId;
		private BrowseDirection browseDirection;
		private NodeId referenceTypeId;
		private boolean includeSubtypes;
		
		/**
		 * Bit NodeClass
		 * 0  Object
		 * 1  Variable
		 * 2  Method
		 * 3  ObjectType
		 * 4  VariableType
		 * 5  ReferenceType
		 * 6  DataType
		 * 7  View
		 */
		private long nodeClassMask;
		
		/**
		 * 0 ReferenceType
		 * 1 IsForward
		 * 2 NodeClass
		 * 3 BrowseName
		 * 4 DisplayName
		 * 5 TypeDefinition
		 */
		private long resultMask;

	}

}
