package opc.ua.services.sets;

import opc.ua.addressspace.datatype.NodeId;
import opc.ua.im.datatype.BaseDataType;
import opc.ua.services.common.DiagnosticInfo;
import opc.ua.services.common.RequestHeader;
import opc.ua.services.common.ResponseHeader;
import opc.ua.services.common.StatusCode;

public class Call {

	/**
	 * request
	 */
	private RequestHeader requestHeader;
	private CallMethodRequest[] methodsToCall;
	
	/** 
	 * response
	 */
	private ResponseHeader responseHeader;
	private CallMethodResult[] results;
	private DiagnosticInfo[] diagnosticInfos;
	
	private class CallMethodRequest {
		private NodeId objectId;
		private NodeId methodId;
		private BaseDataType[] inputArguments;
	}
	
	private class CallMethodResult {
		private StatusCode statusCode;
		private StatusCode[] inputArgumentResults;
		private DiagnosticInfo[] inputArgumentDiagnosticInfos;
		private BaseDataType[] outputArguments;
	}

	
	public RequestHeader getRequestHeader() {
		return requestHeader;
	}

	public void setRequestHeader(RequestHeader requestHeader) {
		this.requestHeader = requestHeader;
	}

	public CallMethodRequest[] getMethodsToCall() {
		return methodsToCall;
	}

	public void setMethodsToCall(CallMethodRequest[] methodsToCall) {
		this.methodsToCall = methodsToCall;
	}

	public ResponseHeader getResponseHeader() {
		return responseHeader;
	}

	public void setResponseHeader(ResponseHeader responseHeader) {
		this.responseHeader = responseHeader;
	}

	public CallMethodResult[] getResults() {
		return results;
	}

	public void setResults(CallMethodResult[] results) {
		this.results = results;
	}

	public DiagnosticInfo[] getDiagnosticInfos() {
		return diagnosticInfos;
	}

	public void setDiagnosticInfos(DiagnosticInfo[] diagnosticInfos) {
		this.diagnosticInfos = diagnosticInfos;
	}
	
}
