package opc.ua.services.sets;

import opc.ua.services.common.Counter;
import opc.ua.services.common.DiagnosticInfo;
import opc.ua.services.common.MonitoringParameters;
import opc.ua.services.common.ReadValueId;
import opc.ua.services.common.RequestHeader;
import opc.ua.services.common.ResponseHeader;
import opc.ua.services.common.StatusCode;
import opc.ua.services.common.TimestampsToReturn;

public class CreateMonitoredItems {

	/**
	 * request
	 */
	private RequestHeader requestHeader;
	
	/** IntegerId */
	private Integer subscriptionId;
	
	private TimestampsToReturn timestampsToReturn;
	private MonitoredItemCreateRequest[] itemsToCreate;

	/**
	 * response 
	 */
	private ResponseHeader responseHeader;
	private MonitoredItemCreateResult[] results;
	private DiagnosticInfo[] diagnosticInfos;

	private class MonitoredItemCreateRequest {
		private ReadValueId itemToMonitor;
		private MonitoringMode monitoringMode;
		private MonitoringParameters requestedParameters;
	}
	
	private class MonitoredItemCreateResult {
		private StatusCode statusCode;
		
		/** IntegerId */
		private Integer monitoredItemId;
		
		/** Duration */
		private long revisedSamplingInterval;
		
		private Counter revisedQueueSize;
		private MonitoringFilterResult filterResult;		
	}
}
