package opc.ua.services.sets;

import opc.ua.addressspace.datatype.NodeId;
import opc.ua.services.common.ApplicationDescription;
import opc.ua.services.common.ApplicationInstanceCertificate;
import opc.ua.services.common.EndpointDescription;
import opc.ua.services.common.RequestHeader;
import opc.ua.services.common.ResponseHeader;
import opc.ua.services.common.SessionAuthenticationToken;
import opc.ua.services.common.SignatureData;
import opc.ua.services.common.SignedSoftwareCertificate;

public class CreateSession {

	/**
	 * request
	 */
	private RequestHeader requestHeader;
	private ApplicationDescription clientDescription;
	private String serverUri;
	private String endpointUri;
	private String sessionName;
	private byte[] clientNonce;
	private ApplicationInstanceCertificate clientCertificate;
	private long requestedSessionTimeout;
	private long maxResponseMessageSize;

	/**
	 * response
	 */
	private ResponseHeader responseHeader;
	private NodeId sessionId;
	private SessionAuthenticationToken authenticationToken;
	private long revisedSessionTimeout;
	private byte[] serverNonce;
	private ApplicationInstanceCertificate serverCertificate;
	private EndpointDescription[] serverEndpoints;
	private SignedSoftwareCertificate[] serverSoftwareCertificates;
	private SignatureData serverSignature;
	private long maxRequestMessageSize;

	public RequestHeader getRequestHeader() {
		return requestHeader;
	}
	public void setRequestHeader(RequestHeader requestHeader) {
		this.requestHeader = requestHeader;
	}
	public ApplicationDescription getClientDescription() {
		return clientDescription;
	}
	public void setClientDescription(ApplicationDescription clientDescription) {
		this.clientDescription = clientDescription;
	}
	public String getServerUri() {
		return serverUri;
	}
	public void setServerUri(String serverUri) {
		this.serverUri = serverUri;
	}
	public String getEndpointUri() {
		return endpointUri;
	}
	public void setEndpointUri(String endpointUri) {
		this.endpointUri = endpointUri;
	}
	public String getSessionName() {
		return sessionName;
	}
	public void setSessionName(String sessionName) {
		this.sessionName = sessionName;
	}
	public byte[] getClientNonce() {
		return clientNonce;
	}
	public void setClientNonce(byte[] clientNonce) {
		this.clientNonce = clientNonce;
	}
	public ApplicationInstanceCertificate getClientCertificate() {
		return clientCertificate;
	}
	public void setClientCertificate(
			ApplicationInstanceCertificate clientCertificate) {
		this.clientCertificate = clientCertificate;
	}
	public long getRequestedSessionTimeout() {
		return requestedSessionTimeout;
	}
	public void setRequestedSessionTimeout(long requestedSessionTimeout) {
		this.requestedSessionTimeout = requestedSessionTimeout;
	}
	public long getMaxResponseMessageSize() {
		return maxResponseMessageSize;
	}
	public void setMaxResponseMessageSize(long maxResponseMessageSize) {
		this.maxResponseMessageSize = maxResponseMessageSize;
	}
	public ResponseHeader getResponseHeader() {
		return responseHeader;
	}
	public void setResponseHeader(ResponseHeader responseHeader) {
		this.responseHeader = responseHeader;
	}
	public NodeId getSessionId() {
		return sessionId;
	}
	public void setSessionId(NodeId sessionId) {
		this.sessionId = sessionId;
	}
	public SessionAuthenticationToken getAuthenticationToken() {
		return authenticationToken;
	}
	public void setAuthenticationToken(
			SessionAuthenticationToken authenticationToken) {
		this.authenticationToken = authenticationToken;
	}
	public long getRevisedSessionTimeout() {
		return revisedSessionTimeout;
	}
	public void setRevisedSessionTimeout(long revisedSessionTimeout) {
		this.revisedSessionTimeout = revisedSessionTimeout;
	}
	public byte[] getServerNonce() {
		return serverNonce;
	}
	public void setServerNonce(byte[] serverNonce) {
		this.serverNonce = serverNonce;
	}
	public ApplicationInstanceCertificate getServerCertificate() {
		return serverCertificate;
	}
	public void setServerCertificate(
			ApplicationInstanceCertificate serverCertificate) {
		this.serverCertificate = serverCertificate;
	}
	public EndpointDescription[] getServerEndpoints() {
		return serverEndpoints;
	}
	public void setServerEndpoints(EndpointDescription[] serverEndpoints) {
		this.serverEndpoints = serverEndpoints;
	}
	public SignedSoftwareCertificate[] getServerSoftwareCertificates() {
		return serverSoftwareCertificates;
	}
	public void setServerSoftwareCertificates(
			SignedSoftwareCertificate[] serverSoftwareCertificates) {
		this.serverSoftwareCertificates = serverSoftwareCertificates;
	}
	public SignatureData getServerSignature() {
		return serverSignature;
	}
	public void setServerSignature(SignatureData serverSignature) {
		this.serverSignature = serverSignature;
	}
	public long getMaxRequestMessageSize() {
		return maxRequestMessageSize;
	}
	public void setMaxRequestMessageSize(long maxRequestMessageSize) {
		this.maxRequestMessageSize = maxRequestMessageSize;
	}

}
