package opc.ua.services.sets;

import opc.ua.addressspace.datatype.NodeId;
import opc.ua.services.common.DiagnosticInfo;
import opc.ua.services.common.RequestHeader;
import opc.ua.services.common.ResponseHeader;
import opc.ua.services.common.StatusCode;

public class DeleteNodes {

	/**
	 * request
	 */
	private RequestHeader requestHeader;
	private DeleteNodesItem[] nodesToDelete;
	
	/**
	 * response
	 */
	private ResponseHeader responseHeader;
	private StatusCode[] results;
	private DiagnosticInfo[] diagnosticInfos;
	
	private class DeleteNodesItem {
		private NodeId nodeid;
		
		/**
		 * TRUE  delete References in TargetNodes that Reference the Node to delete.
		 * FALSE delete only the References for which the Node to delete is the source.
		 */
		private boolean deleteTargetReferences;

		public NodeId getNodeid() {
			return nodeid;
		}

		public void setNodeid(NodeId nodeid) {
			this.nodeid = nodeid;
		}

		public boolean isDeleteTargetReferences() {
			return deleteTargetReferences;
		}

		public void setDeleteTargetReferences(boolean deleteTargetReferences) {
			this.deleteTargetReferences = deleteTargetReferences;
		}
		
	}

	public RequestHeader getRequestHeader() {
		return requestHeader;
	}

	public void setRequestHeader(RequestHeader requestHeader) {
		this.requestHeader = requestHeader;
	}

	public DeleteNodesItem[] getNodesToDelete() {
		return nodesToDelete;
	}

	public void setNodesToDelete(DeleteNodesItem[] nodesToDelete) {
		this.nodesToDelete = nodesToDelete;
	}

	public ResponseHeader getResponseHeader() {
		return responseHeader;
	}

	public void setResponseHeader(ResponseHeader responseHeader) {
		this.responseHeader = responseHeader;
	}

	public StatusCode[] getResults() {
		return results;
	}

	public void setResults(StatusCode[] results) {
		this.results = results;
	}

	public DiagnosticInfo[] getDiagnosticInfos() {
		return diagnosticInfos;
	}

	public void setDiagnosticInfos(DiagnosticInfo[] diagnosticInfos) {
		this.diagnosticInfos = diagnosticInfos;
	}
	
}
