package opc.ua.services.sets;

import opc.ua.addressspace.datatype.NodeId;
import opc.ua.services.common.DiagnosticInfo;
import opc.ua.services.common.ExpandedNodeId;
import opc.ua.services.common.RequestHeader;
import opc.ua.services.common.ResponseHeader;
import opc.ua.services.common.StatusCode;

public class DeleteReferences {

	/**
	 * request
	 */
	private RequestHeader requestHeader;
	private DeleteReferencesItem[] referencesToDelete;
	
	/**
	 * response
	 */
	private ResponseHeader responseHeader;
	private StatusCode[] reslults;
	private DiagnosticInfo[] diagnosticInfos;
	
	private class DeleteReferencesItem {
		private NodeId sourceNodeId;
		private NodeId referenceTypeId;
		private boolean isForward;
		private ExpandedNodeId targetNodeId;
		private boolean deleteBidirectional;
		
		public NodeId getSourceNodeId() {
			return sourceNodeId;
		}
		public void setSourceNodeId(NodeId sourceNodeId) {
			this.sourceNodeId = sourceNodeId;
		}
		public NodeId getReferenceTypeId() {
			return referenceTypeId;
		}
		public void setReferenceTypeId(NodeId referenceTypeId) {
			this.referenceTypeId = referenceTypeId;
		}
		public boolean isForward() {
			return isForward;
		}
		public void setForward(boolean isForward) {
			this.isForward = isForward;
		}
		public ExpandedNodeId getTargetNodeId() {
			return targetNodeId;
		}
		public void setTargetNodeId(ExpandedNodeId targetNodeId) {
			this.targetNodeId = targetNodeId;
		}
		public boolean isDeleteBidirectional() {
			return deleteBidirectional;
		}
		public void setDeleteBidirectional(boolean deleteBidirectional) {
			this.deleteBidirectional = deleteBidirectional;
		}
		
	}

	public RequestHeader getRequestHeader() {
		return requestHeader;
	}

	public void setRequestHeader(RequestHeader requestHeader) {
		this.requestHeader = requestHeader;
	}

	public DeleteReferencesItem[] getReferencesToDelete() {
		return referencesToDelete;
	}

	public void setReferencesToDelete(DeleteReferencesItem[] referencesToDelete) {
		this.referencesToDelete = referencesToDelete;
	}

	public ResponseHeader getResponseHeader() {
		return responseHeader;
	}

	public void setResponseHeader(ResponseHeader responseHeader) {
		this.responseHeader = responseHeader;
	}

	public StatusCode[] getReslults() {
		return reslults;
	}

	public void setReslults(StatusCode[] reslults) {
		this.reslults = reslults;
	}

	public DiagnosticInfo[] getDiagnosticInfos() {
		return diagnosticInfos;
	}

	public void setDiagnosticInfos(DiagnosticInfo[] diagnosticInfos) {
		this.diagnosticInfos = diagnosticInfos;
	}
	
}
