package opc.ua.services.sets;

import opc.ua.addressspace.datatype.NodeId;
import opc.ua.addressspace.datatype.QualifiedName;
import opc.ua.services.common.DiagnosticInfo;
import opc.ua.services.common.NumericRange;
import opc.ua.services.common.RequestHeader;
import opc.ua.services.common.ResponseHeader;
import opc.ua.services.common.StatusCode;
import opc.ua.services.common.TimestampsToReturn;

public class HistoryRead {

	/**
	 * request
	 */
	private RequestHeader requestHeader;
	private HistoryReadDetails historyReadDetails;
	private TimestampsToReturn timestampsToReturn;
	private boolean releaseContinuationPoints;
	private HistoryReadValueId[] nodesToRead;
	
	/**
	 * response
	 */
	private ResponseHeader responseHeader;
	private historyReadResult[] results;
	private DiagnosticInfo[] diagnosticInfos;
	
	private class HistoryReadValueId {
		private NodeId nodeId;
		private NumericRange indexRange;
		private QualifiedName dataEncoding;
		private byte[] continuationPoint;
	}
	
	private class historyReadResult {
		private StatusCode statusCode;
		private byte continuationPoint;
		private HistoryData historyData;
	}
}
