package opc.ua.services.sets;

import opc.ua.services.common.Counter;
import opc.ua.services.common.DiagnosticInfo;
import opc.ua.services.common.MonitoringParameters;
import opc.ua.services.common.RequestHeader;
import opc.ua.services.common.ResponseHeader;
import opc.ua.services.common.StatusCode;
import opc.ua.services.common.TimestampsToReturn;

public class ModifyMonitoredItems {

	/**
	 * request
	 */
	private RequestHeader requestHeader;
	
	/** IntegerId */
	private Integer subscriptionId;
	private TimestampsToReturn timestampsToReturn;
	private MonitoredItemModifyRequest[] itemsToModify;
	
	/**
	 * response
	 */
	private ResponseHeader responseHeader;
	private MonitoredItemModifyResult[] results;
	private DiagnosticInfo[] diagnosticInfos;

	private class MonitoredItemModifyRequest {
		/** IntegerId */
		private Integer monitoredItemId;
		
		private MonitoringParameters requestedParameters;
	}

	private class MonitoredItemModifyResult {
		private StatusCode statusCode;
		/** Duration */
		private long revisedSamplingInterval;
		private Counter revisedQueueSize;
		private MonitoringFilterResult filterResult;
	}
	
}
