package opc.ua.services.sets;

import java.util.Date;
import opc.ua.services.common.ApplicationInstanceCertificate;
import opc.ua.services.common.MessageSecurityMode;
import opc.ua.services.common.RequestHeader;
import opc.ua.services.common.ResponseHeader;
import opc.ua.services.common.SecurityTokenRequestType;

public class OpenSecureChannel {

	/**
	 * request
	 */
	private RequestHeader requestHeader;
	private ApplicationInstanceCertificate clientCertificate;
	
	private SecurityTokenRequestType requestType;	
	private byte[] secureChannelId;
	private MessageSecurityMode securityMode;
	private String securityPolicyUri;
	private byte[] clientNonce;
	private long requestedLifetime;

	/**
	 * response
	 */
	private ResponseHeader responseHeader;
	private ChannelSecurityToken securityToken;
	private byte[] serverNonce;

	private class ChannelSecurityToken {
		  private byte[] channelId;
		  private byte[] tokenId;
		  private Date createdAt;
		  private long revisedLifetime; 
	}

	
	public RequestHeader getRequestHeader() {
		return requestHeader;
	}

	public void setRequestHeader(RequestHeader requestHeader) {
		this.requestHeader = requestHeader;
	}

	public ApplicationInstanceCertificate getClientCertificate() {
		return clientCertificate;
	}

	public void setClientCertificate(
			ApplicationInstanceCertificate clientCertificate) {
		this.clientCertificate = clientCertificate;
	}

	public SecurityTokenRequestType getRequestType() {
		return requestType;
	}

	public void setRequestType(SecurityTokenRequestType requestType) {
		this.requestType = requestType;
	}

	public byte[] getSecureChannelId() {
		return secureChannelId;
	}

	public void setSecureChannelId(byte[] secureChannelId) {
		this.secureChannelId = secureChannelId;
	}

	public MessageSecurityMode getSecurityMode() {
		return securityMode;
	}

	public void setSecurityMode(MessageSecurityMode securityMode) {
		this.securityMode = securityMode;
	}

	public String getSecurityPolicyUri() {
		return securityPolicyUri;
	}

	public void setSecurityPolicyUri(String securityPolicyUri) {
		this.securityPolicyUri = securityPolicyUri;
	}

	public byte[] getClientNonce() {
		return clientNonce;
	}

	public void setClientNonce(byte[] clientNonce) {
		this.clientNonce = clientNonce;
	}

	public long getRequestedLifetime() {
		return requestedLifetime;
	}

	public void setRequestedLifetime(long requestedLifetime) {
		this.requestedLifetime = requestedLifetime;
	}

	public ResponseHeader getResponseHeader() {
		return responseHeader;
	}

	public void setResponseHeader(ResponseHeader responseHeader) {
		this.responseHeader = responseHeader;
	}

	public ChannelSecurityToken getSecurityToken() {
		return securityToken;
	}

	public void setSecurityToken(ChannelSecurityToken securityToken) {
		this.securityToken = securityToken;
	}

	public byte[] getServerNonce() {
		return serverNonce;
	}

	public void setServerNonce(byte[] serverNonce) {
		this.serverNonce = serverNonce;
	}
	  
	
}
