package opc.ua.services.sets;

import opc.ua.services.common.ContentFilter;
import opc.ua.services.common.ContentFilterResult;
import opc.ua.services.common.ContinuationPoint;
import opc.ua.services.common.Counter;
import opc.ua.services.common.DiagnosticInfo;
import opc.ua.services.common.ExpandedNodeId;
import opc.ua.services.common.NumericRange;
import opc.ua.services.common.QueryDataSet;
import opc.ua.services.common.RelativePath;
import opc.ua.services.common.RequestHeader;
import opc.ua.services.common.ResponseHeader;
import opc.ua.services.common.StatusCode;
import opc.ua.services.common.ViewDescription;

public class QueryFirst {

	/**
	 * request
	 */
	private RequestHeader requestHeader;
	private ViewDescription view;
	private NodeTypeDescription[] nodeTypes;
	private ContentFilter filter;
	private Counter maxDataSetsToReturn;
	private Counter maxReferencesToReturn;

	/**
	 * response
	 */
	private ResponseHeader responseHeader;
	private QueryDataSet[] queryDataSets;
	private ContinuationPoint continuationPoint;
	private ParsingResult[] parsingResults;
	private DiagnosticInfo[] diagnosticInfos;
	private ContentFilterResult filterResult;
	
	
	private class NodeTypeDescription {
	    private ExpandedNodeId typeDefinitionNode;
	    private boolean includeSubtypes;
	    private QueryDataDescription[] dataToReturn;
	}

	private class QueryDataDescription {
	    private RelativePath relativePath;
	    /** IntegerId */
	    private Integer attributeId;
	    private NumericRange indexRange;
	}

	private class ParsingResult {
		private StatusCode statusCode;
	    private StatusCode[] dataStatusCodes;
	    private DiagnosticInfo[] dataDiagnosticInfos;
	}


	public RequestHeader getRequestHeader() {
		return requestHeader;
	}

	public void setRequestHeader(RequestHeader requestHeader) {
		this.requestHeader = requestHeader;
	}

	public ViewDescription getView() {
		return view;
	}

	public void setView(ViewDescription view) {
		this.view = view;
	}

	public NodeTypeDescription[] getNodeTypes() {
		return nodeTypes;
	}

	public void setNodeTypes(NodeTypeDescription[] nodeTypes) {
		this.nodeTypes = nodeTypes;
	}

	public ContentFilter getFilter() {
		return filter;
	}

	public void setFilter(ContentFilter filter) {
		this.filter = filter;
	}

	public Counter getMaxDataSetsToReturn() {
		return maxDataSetsToReturn;
	}

	public void setMaxDataSetsToReturn(Counter maxDataSetsToReturn) {
		this.maxDataSetsToReturn = maxDataSetsToReturn;
	}

	public Counter getMaxReferencesToReturn() {
		return maxReferencesToReturn;
	}

	public void setMaxReferencesToReturn(Counter maxReferencesToReturn) {
		this.maxReferencesToReturn = maxReferencesToReturn;
	}

	public ResponseHeader getResponseHeader() {
		return responseHeader;
	}

	public void setResponseHeader(ResponseHeader responseHeader) {
		this.responseHeader = responseHeader;
	}

	public QueryDataSet[] getQueryDataSets() {
		return queryDataSets;
	}

	public void setQueryDataSets(QueryDataSet[] queryDataSets) {
		this.queryDataSets = queryDataSets;
	}

	public ContinuationPoint getContinuationPoint() {
		return continuationPoint;
	}

	public void setContinuationPoint(ContinuationPoint continuationPoint) {
		this.continuationPoint = continuationPoint;
	}

	public ParsingResult[] getParsingResults() {
		return parsingResults;
	}

	public void setParsingResults(ParsingResult[] parsingResults) {
		this.parsingResults = parsingResults;
	}

	public DiagnosticInfo[] getDiagnosticInfos() {
		return diagnosticInfos;
	}

	public void setDiagnosticInfos(DiagnosticInfo[] diagnosticInfos) {
		this.diagnosticInfos = diagnosticInfos;
	}

	public ContentFilterResult getFilterResult() {
		return filterResult;
	}

	public void setFilterResult(ContentFilterResult filterResult) {
		this.filterResult = filterResult;
	}

}
