package opc.ua.services.sets;

import opc.ua.addressspace.datatype.LocalizedText;
import opc.ua.services.common.ApplicationDescription;
import opc.ua.services.common.RequestHeader;
import opc.ua.services.common.ResponseHeader;

public class RegisterServer {

	/**
	 * request
	 */
	private RequestHeader requestHeader;
	private RegisteredServer server;
	
	/**
	 * response
	 */
	private ResponseHeader responseHeader;

	private class RegisteredServer {
		private String serverUri;
		private String productUri;
		private LocalizedText[] serverNames;
		
		/** enum application type */ 
		private ApplicationDescription serverType;
		private String gatewayServerUri;
		private String[] discoveryUrls;
		private String semaphoreFilePath;
		private boolean isOnline;
	}

	public RequestHeader getRequestHeader() {
		return requestHeader;
	}

	public void setRequestHeader(RequestHeader requestHeader) {
		this.requestHeader = requestHeader;
	}

	public RegisteredServer getServer() {
		return server;
	}

	public void setServer(RegisteredServer server) {
		this.server = server;
	}

	public ResponseHeader getResponseHeader() {
		return responseHeader;
	}

	public void setResponseHeader(ResponseHeader responseHeader) {
		this.responseHeader = responseHeader;
	}
	
}
