package opc.ua.services.sets;

import opc.ua.addressspace.datatype.NodeId;
import opc.ua.services.common.DiagnosticInfo;
import opc.ua.services.common.ExpandedNodeId;
import opc.ua.services.common.RelativePath;
import opc.ua.services.common.RequestHeader;
import opc.ua.services.common.ResponseHeader;
import opc.ua.services.common.StatusCode;

public class TranslateBrowsePathsToNodeIds {

	/** 
	 * request
	 */
	private RequestHeader requestHeader;
	private BrowsePath[] browsePaths;
	
	/**
	 * response
	 */
	private ResponseHeader responseHeader;
	private BrowsePathResult[] results;
	private DiagnosticInfo[] diagnosticInfos;
	
	private class BrowsePath {
		private NodeId startingNode;
		private RelativePath relativepath;
	}
	
	private class BrowsePathResult {
		private StatusCode statusCode;
		private BrowsePathTarget[] targets;
	}
	
	private class BrowsePathTarget {
	   private ExpandedNodeId targetId;
	   /** Index */
	   private long remainingPathIndex;
	}


	public RequestHeader getRequestHeader() {
		return requestHeader;
	}

	public void setRequestHeader(RequestHeader requestHeader) {
		this.requestHeader = requestHeader;
	}

	public BrowsePath[] getBrowsePaths() {
		return browsePaths;
	}

	public void setBrowsePaths(BrowsePath[] browsePaths) {
		this.browsePaths = browsePaths;
	}

	public ResponseHeader getResponseHeader() {
		return responseHeader;
	}

	public void setResponseHeader(ResponseHeader responseHeader) {
		this.responseHeader = responseHeader;
	}

	public BrowsePathResult[] getResults() {
		return results;
	}

	public void setResults(BrowsePathResult[] results) {
		this.results = results;
	}

	public DiagnosticInfo[] getDiagnosticInfos() {
		return diagnosticInfos;
	}

	public void setDiagnosticInfos(DiagnosticInfo[] diagnosticInfos) {
		this.diagnosticInfos = diagnosticInfos;
	}
	
}
