package opc.ua.services.sets;

import opc.ua.addressspace.datatype.NodeId;
import opc.ua.services.common.DataValue;
import opc.ua.services.common.DiagnosticInfo;
import opc.ua.services.common.NumericRange;
import opc.ua.services.common.RequestHeader;
import opc.ua.services.common.ResponseHeader;
import opc.ua.services.common.StatusCode;

public class Write {

	/**
	 * request
	 */
	private RequestHeader requestHeader;
	private WriteValue[] nodesToWrite;
	
	/**
	 * response 
	 */
	private ResponseHeader responseHeader;
	private StatusCode[] results;
	private DiagnosticInfo[] diagnosticInfos;
	
	private class WriteValue {
		private NodeId nodeId;
		/** IntegerId */
		private Integer attributeId;
		private NumericRange indexRange;
		private DataValue dataValue;
	}


	public RequestHeader getRequestHeader() {
		return requestHeader;
	}

	public void setRequestHeader(RequestHeader requestHeader) {
		this.requestHeader = requestHeader;
	}

	public WriteValue[] getNodesToWrite() {
		return nodesToWrite;
	}

	public void setNodesToWrite(WriteValue[] nodesToWrite) {
		this.nodesToWrite = nodesToWrite;
	}

	public ResponseHeader getResponseHeader() {
		return responseHeader;
	}

	public void setResponseHeader(ResponseHeader responseHeader) {
		this.responseHeader = responseHeader;
	}

	public StatusCode[] getResults() {
		return results;
	}

	public void setResults(StatusCode[] results) {
		this.results = results;
	}

	public DiagnosticInfo[] getDiagnosticInfos() {
		return diagnosticInfos;
	}

	public void setDiagnosticInfos(DiagnosticInfo[] diagnosticInfos) {
		this.diagnosticInfos = diagnosticInfos;
	}
	
}
