/*
 * Decompiled with CFR 0.152.
 */
package voyager.launcher;

import com.codahale.metrics.jetty9.InstrumentedHandler;
import com.google.common.base.Charsets;
import com.google.common.eventbus.Subscribe;
import java.awt.Desktop;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.swing.JOptionPane;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.impl.ConcurrentUpdateSolrClient;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.MovedContextHandler;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.ShutdownHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import voyager.api.VoyagerFolderProperties;
import voyager.api.domain.model.index.VoyagerIndex;
import voyager.api.event.VoyagerEvents;
import voyager.api.infrastructure.json.JSONObject;
import voyager.api.infrastructure.util.ConfigEncrypter;
import voyager.api.infrastructure.util.DateUtil;
import voyager.api.infrastructure.util.Splash;
import voyager.api.infrastructure.util.StringUtil;
import voyager.api.jni.JNI;
import voyager.app.config.ConfigClass;
import voyager.common.BlowfishConfigEncrypter;
import voyager.common.SiteSettings;
import voyager.common.StartupError;
import voyager.common.VoyagerCommon;
import voyager.common.VoyagerJNI;
import voyager.common.VoyagerURLs;
import voyager.common.http.VoyagerHttpClient;
import voyager.common.platform.win.Kernel32_Ex;
import voyager.common.util.process.VoyagerProcessUtil;
import voyager.common.xml.XStreamer;
import voyager.index.config.VoyagerCoreContainer;
import voyager.index.snapshot.archive.DumpIndexTool;
import voyager.launcher.jetty.JettyServerConfig;
import voyager.launcher.jetty.VoyagerNCSARequestLog;
import voyager.launcher.util.StandardProcessRestarter;
import voyager.logging.VoyagerLogging;
import voyager.logging.log4j.LoggingOutputStream;
import voyager.metrics.VoyagerMetrics;

public abstract class VoyagerLauncher {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String MAX_FORM_CONTENT_SIZE = "jetty.maxFormContentSize";
    public static final String REQUEST_HEADER_SIZE = "jetty.RequestHeaderSize";
    public static final String THREAD_POOL_MIN = "jetty.thread.pool.min";
    public static final String THREAD_POOL_MAX = "jetty.thread.pool.max";
    protected Server server;
    protected VoyagerURLs urls;
    protected File data;
    public String gotopath = null;
    protected Map<String, Integer> ports = new LinkedHashMap<String, Integer>();

    public void shutdownWithError(String msg, Throwable t) {
        VoyagerCommon.shutdownError((String)msg).error(t).data(this.data).log(this.log).popup(true).shutdown();
    }

    public abstract boolean openVoyagerWindow(String var1);

    public VoyagerURLs readURL(SiteSettings siteSettings) {
        if (System.getProperty("port.ajp") != null) {
            this.shutdownWithError("Voyager no longer supports AJP", null);
        }
        VoyagerURLs urls = VoyagerURLs.create((SiteSettings)siteSettings);
        VoyagerCommon.setURLs((VoyagerURLs)urls);
        return urls;
    }

    public File getDataDir() {
        this.data = VoyagerFolderProperties.getDataDir();
        return this.data;
    }

    protected static String getCurrentlyRunningVersion(String url) throws Exception {
        URL uuu = new URL(url + "?VOYAGERINFO");
        Splash.screen().show("Check for other instance: " + uuu);
        URLConnection connection = uuu.openConnection();
        connection.setConnectTimeout(1500);
        DataInputStream dis = new DataInputStream(connection.getInputStream());
        String v = IOUtils.toString((InputStream)dis);
        if (v != null) {
            JSONObject json = new JSONObject(v);
            return json.getString("version");
        }
        return null;
    }

    public void abortIfAlreadyRunning() {
        block8: {
            String url = this.urls.base();
            try {
                String v = VoyagerLauncher.getCurrentlyRunningVersion(url);
                if (v == null) break block8;
                boolean isrestart = "true".equals(System.getProperty(StandardProcessRestarter.FLAG));
                if (isrestart) {
                    System.out.println("Restart Requested. PID=" + VoyagerJNI.getPID());
                    for (int i = 0; i < 30; ++i) {
                        System.out.println("Waiting for restart (" + i + ") running=" + v);
                        VoyagerCommon.sleep((int)1100);
                        v = VoyagerLauncher.getCurrentlyRunningVersion(url);
                        if (v != null) continue;
                        System.out.println("Restart complete [" + i + "]");
                        return;
                    }
                }
                if (!VoyagerCommon.getInstance().version.equals(v)) {
                    String err = "A different version of voyager is already running: " + v + " != " + VoyagerCommon.getInstance().version + "\n" + url + "  [" + System.getProperty("port") + "]";
                    Splash.screen().show(err);
                    this.shutdownWithError(err, null);
                }
                System.out.println("Already Running: " + url);
                Splash.screen().hide();
                if (!Splash.headless()) {
                    try {
                        Desktop.getDesktop().browse(new URI(url));
                    }
                    catch (IOException | URISyntaxException e) {
                        e.printStackTrace();
                    }
                }
                System.exit(0);
            }
            catch (Exception e) {
                this.log.trace("Error reading status", (Throwable)e);
            }
        }
    }

    public void showShutdownPopup() {
        int response = JOptionPane.showConfirmDialog(null, "Are you sure you want to shutdown Voyager?", "Shutdown?", 0, 3);
        if (response == 0) {
            this.doShutdown();
        }
    }

    public void doShutdown() {
        try {
            this.server.stop();
        }
        catch (Exception e1) {
            this.log.error("error", (Throwable)e1);
        }
        this.log.info("Exiting...");
        VoyagerCommon.shutdown((int)0);
    }

    public void initLogging() throws FileNotFoundException, IOException {
        Splash.screen().show("initialize logging");
        VoyagerLogging.boot();
        System.setErr(new PrintStream((OutputStream)new LoggingOutputStream(LogManager.getRootLogger(), Level.WARN, "stderr"), true, Charsets.UTF_8.name()));
        System.setOut(new PrintStream((OutputStream)new LoggingOutputStream(LogManager.getRootLogger(), Level.INFO, "stdout"), true, Charsets.UTF_8.name()));
    }

    public static int getIntProperty(String name, int val) {
        String v = System.getProperty(name);
        if (v != null) {
            return Integer.parseInt(v);
        }
        return val;
    }

    public void initServer(SiteSettings siteSettings) throws Exception {
        String stopKey;
        File f;
        String webAppDefaultPath;
        ClassLoader loader;
        URL webAppDefault;
        WebAppContext ctx;
        Splash.screen().show("initialize server");
        JettyServerConfig cfg = new JettyServerConfig((ConfigEncrypter)new BlowfishConfigEncrypter());
        cfg.load();
        this.server = new Server((ThreadPool)cfg.newThreadPool());
        HttpConfiguration http_config = cfg.newtHttpConfiguration();
        int port = this.urls.port();
        if (port > 0) {
            ServerConnector http = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(http_config)});
            http.setPort(port);
            http.setIdleTimeout(30000L);
            this.server.addConnector((Connector)http);
            this.ports.put("http", port);
        }
        if (cfg.getSsl().isEnabled()) {
            Optional<SslContextFactory> scf = cfg.newSslContextFactory();
            if (scf.isPresent()) {
                HttpConfiguration https_config = new HttpConfiguration(http_config);
                https_config.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
                ServerConnector sslConnector = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory(scf.get(), "http/1.1"), new HttpConnectionFactory(https_config)});
                sslConnector.setPort(cfg.getSsl().getPort());
                this.server.addConnector((Connector)sslConnector);
                this.ports.put("https", cfg.getSsl().getPort());
            } else {
                this.log.error("Unable to create an SSL context factory, SSL is disabled");
            }
        }
        if ((ctx = new WebAppContext()).getMimeTypes() == null) {
            ctx.setMimeTypes(new MimeTypes());
        }
        if ((webAppDefault = (loader = ClassLoader.getSystemClassLoader()).getResource(webAppDefaultPath = "voyager/launcher/jetty/webappdefault.xml")) == null) {
            loader = this.getClass().getClassLoader();
            webAppDefault = loader.getResource(webAppDefaultPath);
        }
        ctx.setDefaultsDescriptor(webAppDefault.toExternalForm());
        ctx.setMaxFormContentSize(300000);
        String webxml = null;
        String v = System.getProperty("web.xml");
        if (v != null && (f = new File(v)).exists()) {
            webxml = f.getAbsolutePath();
        }
        if (webxml == null) {
            if (v == null) {
                v = "web.xml";
            } else {
                this.log.info("Loading web.xml: " + v);
            }
            webxml = loader.getResource(ConfigClass.class.getPackage().getName().replace('.', '/') + "/" + v).toExternalForm();
        }
        this.log.info("Loading web.xml: {}", webxml);
        Splash.screen().show("Loading: " + webxml);
        ctx.setDescriptor(webxml);
        SessionManager sessions = ctx.getSessionHandler().getSessionManager();
        sessions.setMaxInactiveInterval(15);
        MBeanContainer mbContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
        this.server.addBean((Object)mbContainer);
        HandlerCollection handlers = new HandlerCollection(false);
        String context = this.urls.context();
        ctx.setServer(this.server);
        ctx.setAllowNullPathInfo(false);
        ctx.setContextPath(context);
        File web = VoyagerFolderProperties.getWebDir();
        if (web.exists()) {
            ctx.setResourceBase(web.getAbsolutePath());
            ctx.setWelcomeFiles(new String[]{"index.html"});
            ctx.setAliasChecks(Arrays.asList(new ContextHandler.ApproveAliases()));
        } else {
            this.log.warn("Missing web folder: {}", (Object)web);
            Resource base = Resource.newClassPathResource((String)"voyager");
            ctx.setBaseResource(base);
        }
        handlers.addHandler((Handler)ctx);
        if (context.length() > 1) {
            this.log.info("Running on context: " + context);
            MovedContextHandler m = new MovedContextHandler();
            m.setContextPath("");
            m.setNewContextURL(context);
            m.setDiscardPathInfo(true);
            m.setDiscardQuery(true);
            m.setPermanent(true);
            handlers.addHandler((Handler)m);
        }
        if (siteSettings != null && siteSettings.isNCSALoggingEnabled()) {
            File afile = new File(VoyagerFolderProperties.getLogsDir(), "voyager-access-yyyy_mm_dd.log");
            VoyagerNCSARequestLog requestLog = new VoyagerNCSARequestLog(afile.getAbsolutePath());
            requestLog.setRetainDays(7);
            requestLog.setAppend(true);
            requestLog.setExtended(true);
            requestLog.setLogTimeZone("GMT");
            RequestLogHandler requestLogHandler = new RequestLogHandler();
            requestLogHandler.setRequestLog((RequestLog)requestLog);
            handlers.addHandler((Handler)requestLogHandler);
        }
        if ((stopKey = System.getProperty("stop.key")) == null) {
            stopKey = StringUtil.randomPasswordString((int)6);
            this.log.info("Generating stop key: {}", (Object)stopKey);
        }
        handlers.addHandler((Handler)new ShutdownHandler(stopKey, true, false));
        VoyagerMetrics metrics = VoyagerMetrics.get();
        if (metrics.config().isEnabled("http", false)) {
            InstrumentedHandler h = new InstrumentedHandler(metrics.registry(), metrics.name(new String[]{"http"}));
            h.setHandler((Handler)handlers);
            this.server.setHandler((Handler)h);
        } else {
            this.server.setHandler((Handler)handlers);
        }
        this.server.setDumpAfterStart(false);
        this.server.setDumpBeforeStop(false);
        this.server.setStopAtShutdown(true);
        Splash.screen().show("Server Configured");
    }

    public void dumpIndexTo(String where) throws Throwable {
        ConcurrentUpdateSolrClient dumpSolr = null;
        File dumpIndex = null;
        if (where.startsWith("http")) {
            dumpSolr = new ConcurrentUpdateSolrClient(where, 50, 3);
            try {
                dumpSolr.query((SolrParams)new SolrQuery("*:*"));
            }
            catch (Exception ex) {
                System.err.println("Unable to connect to: " + where);
                return;
            }
        } else {
            dumpIndex = new File(where);
            if (dumpIndex.exists()) {
                this.shutdownWithError("DumpFile already exists: " + dumpIndex.getAbsolutePath(), null);
            }
            if (!dumpIndex.getParentFile().exists()) {
                this.shutdownWithError("DumpFile folder must exist: " + dumpIndex.getAbsolutePath(), null);
            }
        }
        File data = this.getDataDir();
        if (data == null) {
            this.shutdownWithError("missing required property: data.dir", null);
        }
        VoyagerCoreContainer container = new VoyagerCoreContainer();
        EmbeddedSolrServer solr = new EmbeddedSolrServer((CoreContainer)container, VoyagerIndex.v0.id);
        DumpIndexTool tool = new DumpIndexTool();
        if (dumpIndex != null) {
            tool.writeIndex((SolrClient)solr, dumpIndex);
            System.out.println("wrote: " + dumpIndex.getAbsolutePath());
        } else {
            int count = tool.writeIndex((SolrClient)solr, (SolrClient)dumpSolr, System.out);
            System.out.println("[DUMP] Loaded [" + count + "] writing to disk...");
            dumpSolr.commit(true, true);
            System.out.println("[DUMP] done.");
        }
    }

    public void launch(boolean logging) throws Exception {
        String jettyHome;
        long startTime = System.currentTimeMillis();
        if (this.getDataDir() == null) {
            this.shutdownWithError("missing required property: data.dir", null);
        }
        SiteSettings siteSettings = SiteSettings.load();
        if (this.urls == null) {
            this.urls = this.readURL(siteSettings);
        }
        this.abortIfAlreadyRunning();
        VoyagerCommon.forceSystemUTF8();
        if (!this.data.exists()) {
            this.shutdownWithError("data.dir does not exists: '" + this.data.getCanonicalPath() + "'", null);
        }
        if (!this.data.canWrite()) {
            String user = System.getProperty("user.name");
            String path = this.data.getCanonicalPath();
            String err = "Check write permissions for data directory: " + path + "  (user=" + user + ")";
            this.shutdownWithError(err, null);
        }
        if (logging) {
            this.initLogging();
        }
        this.log.info(":::::::::::::::");
        this.log.info("VERSION: " + VoyagerCommon.getInstance().version + " [" + DateUtil.FORMAT.DATETIME4.format(VoyagerCommon.getInstance().build_date) + "]");
        this.log.info("data: " + this.data.getAbsolutePath());
        this.log.info("url: " + this.urls.base());
        this.log.info("port: " + this.urls.port());
        this.log.info("context: " + this.urls.context());
        this.log.info("arch: " + JNI.ARCH.toString());
        this.log.info("MAIN: " + VoyagerJNI.getMainClassName());
        this.log.info("INFO: " + XStreamer.json.toXML((Object)VoyagerCommon.getSystemInfo()));
        this.initServer(siteSettings);
        if (SystemUtils.IS_OS_WINDOWS) {
            try {
                Kernel32_Ex.INSTANCE.SetErrorMode(1);
            }
            catch (Exception ex) {
                this.log.warn("error setting windows error level", (Throwable)ex);
            }
        }
        if ((jettyHome = System.getProperty("jetty.home")) == null) {
            File f = new File(VoyagerFolderProperties.getTempDir(), "jetty/work");
            f.mkdirs();
            System.setProperty("jetty.home", f.getParentFile().getAbsolutePath());
        }
        VoyagerEvents.get().bus("core").post((Object)new StartupListener());
        try {
            this.beforeServerStarts();
            this.log.info(">>> STARTING VOYAGER <<<");
            Splash.screen().show("starting host");
            this.server.start();
            long elapsed = System.currentTimeMillis() - startTime;
            this.log.info(">>> SERVER STARTED <<< " + DurationFormatUtils.formatDurationHMS((long)elapsed));
            this.afterServerStarts();
            Splash.screen().hide();
            this.server.join();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error("error", (Throwable)e);
            Splash.screen().hide();
            this.shutdownWithError("Error starting voyager: " + e.getMessage(), e);
        }
    }

    public abstract void beforeServerStarts() throws IOException;

    protected abstract void afterServerStarts();

    private boolean checkStartupParam(String a, String[] args) {
        if (a.startsWith("--kill")) {
            Splash.screen().hide();
            String arg = null;
            int idx = a.indexOf(61);
            if (idx > 0) {
                arg = a.substring(idx + 1);
            }
            File file = VoyagerFolderProperties.getAppsDir();
            try {
                int count = VoyagerProcessUtil.killall((String)file.getAbsolutePath());
                System.out.println("Killed: " + count + " processes");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            System.exit(0);
        }
        if (a.equals("--info")) {
            Properties p = System.getProperties();
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                System.out.println("Info(PROP) " + entry.getKey() + " = " + entry.getValue());
            }
            for (Map.Entry<Object, Object> entry : System.getenv().entrySet()) {
                System.out.println("Info(ENV) " + (String)entry.getKey() + " = " + (String)entry.getValue());
            }
            return true;
        }
        return false;
    }

    public void init(String[] args) {
        File profile = null;
        System.out.println("Running:" + this.getClass().getName());
        try {
            System.out.println("trying to get localhost...");
            InetAddress addr = InetAddress.getLocalHost();
            System.out.println("HOST:" + addr.getHostName());
            System.out.println("IP:" + addr.getHostAddress());
            System.out.flush();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            System.err.flush();
        }
        System.out.flush();
        VoyagerCommon.setJVMTemDir();
        String dumpIndex = null;
        boolean logging = true;
        this.readURL(SiteSettings.load());
        if (args != null && args.length > 0) {
            boolean hasConsolePassthough = false;
            for (String a : args) {
                System.out.println(" >" + a);
                if (a.endsWith(".vprofile")) {
                    profile = new File(a);
                    continue;
                }
                if ("-console".equals(a)) {
                    hasConsolePassthough = true;
                    continue;
                }
                if ("--logging=false".equals(a)) {
                    logging = false;
                    System.out.println("Don't init logging");
                    continue;
                }
                if (a.startsWith("--dump=")) {
                    Splash.screen().hide();
                    dumpIndex = a.substring(a.indexOf(61) + 1).trim();
                    continue;
                }
                if (this.checkStartupParam(a, args)) continue;
                System.out.println("Unknown command line: " + a);
            }
        }
        if (profile != null && profile.exists()) {
            try {
                this.gotopath = "manage/settings/profiles?load=" + URLEncoder.encode(profile.getAbsolutePath(), "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        try {
            if (dumpIndex != null) {
                this.dumpIndexTo(dumpIndex);
                System.exit(0);
            } else {
                VoyagerCommon.scheduler.schedule(new Runnable(){

                    @Override
                    public void run() {
                        VoyagerHttpClient.initProxyVole();
                    }
                }, 1L, TimeUnit.SECONDS);
                this.launch(logging);
            }
        }
        catch (Throwable t) {
            String msg = t.getLocalizedMessage();
            if (msg == null || msg.length() < 1) {
                msg = t.toString();
            }
            this.shutdownWithError(msg, t);
        }
        System.out.println("done. [PID=" + VoyagerJNI.getPID() + "]");
    }

    static {
        VoyagerCommon.initGeoToolsReferencing();
    }

    class StartupListener {
        StartupListener() {
        }

        @Subscribe
        public void handle(StartupError e) {
            Splash.screen().hide();
            VoyagerLauncher.this.log.error(e.message, e.error);
            VoyagerLauncher.this.shutdownWithError(e.message, e.error);
        }
    }
}

