/*
 * Decompiled with CFR 0.152.
 */
package voyager.launcher;

import com.google.common.base.Strings;
import java.awt.AWTException;
import java.awt.Desktop;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import voyager.api.VoyagerFolderProperties;
import voyager.api.infrastructure.util.Splash;
import voyager.common.VoyagerCommon;
import voyager.common.license.License;
import voyager.common.license.v13.VoyagerLicenseManager;
import voyager.launcher.VoyagerLauncher;
import voyager.launcher.VoyagerServerService;

public class VoyagerServer
extends VoyagerLauncher {
    protected TrayIcon trayIcon;

    public static void setNimbusLookAndFeel() {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean openVoyagerWindow(String url) {
        try {
            Desktop.getDesktop().browse(new URI(url));
            return true;
        }
        catch (Exception e) {
            this.log.warn("Error opening {}", (Object)url, (Object)e);
            return false;
        }
    }

    public boolean openOnDesktop(File url) {
        try {
            this.log.info("Open on Desktop: {}", (Object)url);
            Desktop.getDesktop().open(url);
            return true;
        }
        catch (Exception e) {
            this.log.warn("Error opening {}", (Object)url, (Object)e);
            return false;
        }
    }

    @Override
    public void beforeServerStarts() throws IOException {
    }

    @Override
    protected void afterServerStarts() {
        String goTo;
        final String url = this.urls.base();
        String string = goTo = this.gotopath != null ? url + this.gotopath : url;
        if (Splash.headless()) {
            this.log.info("Voyager running and available at {}", (Object)goTo);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Splash.screen().show("opening voyager window");
                VoyagerServer.this.openVoyagerWindow(goTo);
                Splash.screen().show("Initializing Menu");
                SystemTray tray = SystemTray.getSystemTray();
                PopupMenu popup = VoyagerServer.this.createPopupMenu();
                try {
                    BufferedImage image = VoyagerCommon.loadIcon32_orCreate();
                    VoyagerServer.this.ports.put("discovery", VoyagerFolderProperties.getDiscoveryPortOrDefault());
                    License lic = VoyagerLicenseManager.get().getCurrentLicense();
                    String ttip = "Voyager Server\n" + VoyagerCommon.getInstance().version;
                    if (lic != null) {
                        ttip = ttip + " : " + lic.getProduct();
                    }
                    ttip = ttip + "\n" + VoyagerServer.this.ports;
                    if (!Strings.isNullOrEmpty((String)url)) {
                        ttip = ttip + "\n" + url;
                    }
                    VoyagerServer.this.trayIcon = new TrayIcon(image, ttip, popup);
                    VoyagerServer.this.trayIcon.setImageAutoSize(true);
                    VoyagerServer.this.trayIcon.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            VoyagerServer.this.openVoyagerWindow(url);
                        }
                    });
                    tray.add(VoyagerServer.this.trayIcon);
                }
                catch (AWTException e) {
                    System.err.println("TrayIcon could not be added.");
                    VoyagerServer.this.log.error("Unable to load tray icon", (Throwable)e);
                }
                Splash.screen().show("Initializing Voyager");
                Splash.screen().hide();
            }
        });
    }

    protected void showVoyagerRunningBaloon() {
        if (this.trayIcon != null) {
            this.trayIcon.displayMessage("Voyager is still running.", "Voyager will continue running in the background so that indexing completes normally.To shutdown, right-click and select 'Shutdown'.\n\n", TrayIcon.MessageType.INFO);
        }
    }

    private void make(String name, final File dir, Set<File> skip, PopupMenu menu) {
        if (skip.contains(dir)) {
            return;
        }
        skip.add(dir);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        VoyagerServer.this.openOnDesktop(dir);
                    }
                });
            }
        };
        PopupMenu item = new PopupMenu(name);
        item.addActionListener(listener);
        MenuItem sub = new MenuItem(dir.getAbsolutePath());
        sub.addActionListener(listener);
        item.add(sub);
        menu.add(item);
    }

    private PopupMenu getFolderSubMenu() {
        PopupMenu menu = new PopupMenu("Locate");
        HashSet<File> used = new HashSet<File>();
        this.make("Install", VoyagerFolderProperties.getAppsDir(), used, menu);
        this.make("Data", VoyagerFolderProperties.getDataDir(), used, menu);
        this.make("Meta", VoyagerFolderProperties.getMetaDir(), used, menu);
        this.make("Logs", VoyagerFolderProperties.getLogsDir(), used, menu);
        this.make("Config", VoyagerFolderProperties.getConfigDir(), used, menu);
        return menu;
    }

    private PopupMenu createPopupMenu() {
        ActionListener openVoyagerAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VoyagerServer.this.openVoyagerWindow(VoyagerCommon.getBaseURL());
            }
        };
        MenuItem itemShow = new MenuItem("Explore");
        MenuItem itemManage = new MenuItem("Manage Voyager");
        MenuItem itemExit = new MenuItem("Shutdown");
        itemShow.addActionListener(openVoyagerAction);
        itemManage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        VoyagerServer.this.openVoyagerWindow(VoyagerServer.this.urls.base() + "manage/");
                    }
                });
            }
        });
        itemExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VoyagerServer.this.showShutdownPopup();
            }
        });
        PopupMenu popup = new PopupMenu();
        popup.add(itemShow);
        popup.add(itemManage);
        popup.add(this.getFolderSubMenu());
        popup.addSeparator();
        popup.add(itemExit);
        return popup;
    }

    public static void main(String[] args) {
        VoyagerLauncher launcher = new VoyagerServer();
        if (args != null && args.length > 0) {
            for (String a : args) {
                if (!"--service".equals(a)) continue;
                launcher = new VoyagerServerService();
            }
        }
        launcher.init(args);
    }

    static {
        System.setProperty("javax.swing.adjustPopupLocationToFit", "false");
        VoyagerServer.setNimbusLookAndFeel();
    }
}

