/*
 * Decompiled with CFR 0.152.
 */
package voyager.launcher.jetty;

import java.util.Optional;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import voyager.api.infrastructure.util.ConfigEncrypter;
import voyager.common.ServerConfig;

public class JettyServerConfig
extends ServerConfig {
    private static final long serialVersionUID = 1L;

    public JettyServerConfig(ConfigEncrypter encrypter) {
        super(encrypter);
    }

    public HttpConfiguration newtHttpConfiguration() {
        HttpConfiguration http_config = new HttpConfiguration();
        if (this.getSsl().isEnabled()) {
            http_config.setSecureScheme("https");
            http_config.setSecurePort(this.getSsl().getPort());
        }
        http_config.setOutputBufferSize(this.getHttp().getOutputBufferSize());
        http_config.setRequestHeaderSize(this.getHttp().getRequestHeaderSize());
        http_config.setResponseHeaderSize(this.getHttp().getResponseHeaderSize());
        http_config.setSendServerVersion(true);
        http_config.setSendDateHeader(false);
        return http_config;
    }

    public QueuedThreadPool newThreadPool() {
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMinThreads(this.getThreadPool().getMinThreads());
        threadPool.setMaxThreads(this.getThreadPool().getMaxThreads());
        return threadPool;
    }

    public Optional<SslContextFactory> newSslContextFactory() {
        boolean valid;
        SslContextFactory scf = null;
        ServerConfig.KeyStore ks = this.getSsl().getKeyStore();
        boolean bl = valid = ks != null && ks.isValid();
        if (valid) {
            String kmp;
            ServerConfig.KeyStore ts;
            scf = new SslContextFactory();
            scf.setKeyStorePath(ks.getFile().getAbsolutePath());
            String ksp = ks.getPassword();
            if (ksp != null) {
                scf.setKeyStorePassword(ksp);
            }
            if ((ts = this.getSsl().getTrustStore()) != null && ts.isValid()) {
                scf.setTrustStorePath(ts.getFile().getAbsolutePath());
                String tsp = ts.getPassword();
                if (tsp != null) {
                    scf.setTrustStorePassword(tsp);
                }
            }
            if ((kmp = this.getSsl().getKeyManagerPassword()) != null) {
                scf.setKeyManagerPassword(kmp);
            }
            scf.setExcludeCipherSuites(new String[]{"SSL_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA"});
            scf.setWantClientAuth(this.getSsl().isClientCertificateEnabled());
        }
        return Optional.ofNullable(scf);
    }
}

