/*
 * Decompiled with CFR 0.152.
 */
package voyager.launcher.jetty;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Enumeration;
import org.eclipse.jetty.server.NCSARequestLog;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;

public class VoyagerNCSARequestLog
extends NCSARequestLog {
    boolean logHeaders = false;

    public VoyagerNCSARequestLog(String filename) {
        super(filename);
        this.setExtended(true);
        this.logHeaders = Boolean.getBoolean("ncsa.headers");
    }

    protected void logExtended(Request request, Response response, StringBuilder b) throws IOException {
        long durration = System.currentTimeMillis() - request.getTimeStamp();
        b.append(' ').append(durration);
        b.append(' ').append(request.getAttribute("shiro.subject.id"));
        if (this.logHeaders) {
            String h;
            b.append("\n");
            int max = 0;
            Enumeration it = request.getHeaderNames();
            while (it.hasMoreElements()) {
                h = (String)it.nextElement();
                max = Math.max(max, h.length());
            }
            it = request.getHeaderNames();
            while (it.hasMoreElements()) {
                h = (String)it.nextElement();
                b.append("\t").append(Strings.padEnd((String)h, (int)max, (char)' ')).append(": ").append(request.getHeader(h)).append("\n");
            }
        }
    }
}

