/*
 * Decompiled with CFR 0.152.
 */
package voyager.launcher.util;

import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SystemUtils;
import org.hyperic.sigar.win32.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import voyager.api.infrastructure.util.Registry;
import voyager.api.process.ProcessSetupInfo;
import voyager.api.util.NamedThreadFactory;
import voyager.common.VoyagerCommon;
import voyager.common.VoyagerJNI;
import voyager.common.exec.CommandLine;
import voyager.common.exec.DefaultExecutor;
import voyager.common.exec.ExecuteStreamHandler;
import voyager.common.exec.PumpStreamHandler;
import voyager.common.process.ProcessLogHelper;
import voyager.common.process.ProcessRestarter;
import voyager.discovery.DiscoveryNodeRunner;

public class StandardProcessRestarter
implements ProcessRestarter {
    static final Logger log = LoggerFactory.getLogger(StandardProcessRestarter.class);
    public static String FLAG = "isrestart";
    public static String LAUNCHER_EXE_REGEX = ".*VoyagerServer.{0,4}\\.exe.*";
    private ExecutorService es = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("voyager-restart"));

    public void restart(String reason) {
        this.es.submit(() -> this.shutdown(reason, true));
    }

    private void shutdown(String reason, boolean restart) {
        String action;
        String what = action = restart ? "Restart" : "Shutdown";
        DiscoveryNodeRunner runner = (DiscoveryNodeRunner)Registry.get(DiscoveryNodeRunner.class);
        String service = StandardProcessRestarter.getCurrentServiceName();
        what = service != null ? what + " Service: " + service : what + " Voyager";
        runner.doIndexHistory(what, reason, null);
        VoyagerCommon.sleep((int)750);
        log.info("=========================================");
        log.info("[{}] {} {}", new Object[]{action, what, reason});
        log.info("=========================================");
        try {
            DefaultExecutor exe = new DefaultExecutor();
            CommandLine cmd = null;
            if (service == null) {
                cmd = this.getCurrentCommandLine();
            } else {
                cmd = null;
                log.error("TODO... need to restart service: " + service);
            }
            exe.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)System.out, (OutputStream)System.err));
            exe.setExitValues(new int[]{0, 1});
            VoyagerCommon.scheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    log.info("Calling System.exit(0) and waiting for restart");
                    VoyagerCommon.sleep((int)150);
                    System.exit(0);
                }
            }, 2L, TimeUnit.SECONDS);
            if (restart) {
                log.info("Calling: {}", (Object)cmd);
                int res = exe.execute(cmd);
                log.info("Got={}", (Object)res);
            }
        }
        catch (Exception ex) {
            log.warn("error running restart", (Throwable)ex);
        }
    }

    public static String getCurrentServiceName() {
        if (!SystemUtils.IS_OS_WINDOWS) {
            return null;
        }
        try {
            for (Object s : Service.getServiceNames()) {
                String n = (String)s;
                try {
                    long pid = VoyagerJNI.sigar().getServicePid(n);
                    if (pid != VoyagerJNI.getPID()) continue;
                    return n;
                }
                catch (Exception ex) {
                    log.warn("error reading pid for service: {} :: {}", (Object)n, (Object)ex.toString());
                }
            }
        }
        catch (Throwable ex) {
            log.error("error reading services", ex);
        }
        return null;
    }

    public CommandLine getCurrentCommandLine() {
        ProcessSetupInfo info = ProcessLogHelper.getSetup((long)VoyagerJNI.getPID());
        CommandLine cmd = new CommandLine(info.getExe());
        String vmParameterPrefix = Pattern.matches(LAUNCHER_EXE_REGEX, info.getExe()) ? "-J" : "";
        String flag = vmParameterPrefix + "-D" + FLAG + "=true";
        String[] args = info.getArgs();
        List<String> l = Arrays.stream(args).filter(e -> !e.startsWith("-agentlib") && !e.equals(flag)).collect(Collectors.toList());
        cmd.addArgument(flag);
        if (!l.isEmpty()) {
            l.remove(0);
            args = l.toArray(new String[l.size()]);
            cmd.addArguments(args);
        }
        System.err.println(cmd);
        return cmd;
    }
}

