﻿using System;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace CxModelDemo
{
    public partial class Form1 : Form
    {
        // kolik kroku simulace chceme udelat? napr. v minutach
        public static readonly int SimulateStepCount = 300;

        // Pomocna trida pro krokovani modelu
        class ModelRunWorker
        {
            // pripravena hodnota pro injektaz udalosti
            public static Nullable<double> InjectedValue = null;

            // hlavni krokovaci metoda; bude se provadet na pozadi ve vlastnim vlakne
            public static void RunModel(IProgress<Model.ModelState> progress)
            {
                // vytvoreni a inicializace modelu
                Model mdl = new Model();
                mdl.Initialize();

                // krokujeme model
                for (int i = 0; i < SimulateStepCount; i++)
                {
                    // pokud jsme si vyzadali injektaz hodnoty, injektujeme ji zde
                    // tohle by v modelu cukrovky bylo napr. snezene jidlo
                    if (InjectedValue.HasValue)
                    {
                        // nase "jidlo" putuje do kompartmentu G1, pricteme jej tam a vymazeme InjectedValue
                        mdl.state.G1 += InjectedValue.Value;
                        InjectedValue = null;
                    }

                    // krok modelu
                    mdl.Step();

                    // reportujeme do GUI, jak jsme postoupili
                    progress.Report(mdl.state);

                    // a nejake zpozdeni, abychom mohli videt jak se to vyviji
                    Task.Delay(100).Wait();
                }
            }
        }

        public Form1()
        {
            InitializeComponent();
        }

        private async void StartButton_Click(object sender, EventArgs e)
        {
            // vymazeme data z grafu
            chart1.Series[0].Points.Clear();
            chart1.Series[1].Points.Clear();

            int step = 0;
            // sem bude task na pozadi reportovat progress - vzdycky jen zobrazime nove hodnoty
            var progress = new Progress<Model.ModelState>((state) => {
                // pridame hodnoty do grafu
                chart1.Series[0].Points.AddXY(step, state.G1);
                chart1.Series[1].Points.AddXY(step, state.G2);
                step++;

                // pro efekt - posuneme progressbar
                SimulationProgress.Value = 100 * step / SimulateStepCount;
            });

            // stav GUI
            StartButton.Enabled = false;
            InjectEventButton.Enabled = true;

            // spustime task na pozadi
            await Task.Run(() => ModelRunWorker.RunModel(progress));

            StartButton.Enabled = true;
            InjectEventButton.Enabled = false;
        }

        private void InjectEventButton_Click(object sender, EventArgs e)
        {
            // tady jen do modelu neco nacpeme, to muze v realnych modelech cukrovky byt treba jidlo nebo injektovany inzulin
            ModelRunWorker.InjectedValue = 5.0;
        }
    }
}
