﻿using System;
using System.IO;
using System.Runtime.Serialization.Formatters.Binary;

// jen pomocne metody pro hlubokou kopii kontejneru
public static class ExtensionMethods
{
    public static T DeepClone<T>(this T a)
    {
        using (MemoryStream stream = new MemoryStream())
        {
            BinaryFormatter formatter = new BinaryFormatter();
            formatter.Serialize(stream, a);
            stream.Position = 0;
            return (T)formatter.Deserialize(stream);
        }
    }
}

namespace CxModelDemo
{
    public class Model
    {
        // Tahle prepravka konzervuje stav modelu (tj. mnozstvi latek v kompartmentech)
        [Serializable]
        public class ModelState {
            public double G1;
            public double G2;
        }

        // soucasny stav modelu
        public ModelState state;

        // nas vymysleny prenosovy parametr
        private static readonly double TransferRate1 = 0.06;

        // inicializace modelu na pocatecni hodnoty
        public void Initialize()
        {
            state = new ModelState();

            // nastavime pocatecni hodnoty na nejake nase vymyslene
            state.G1 = 10;
            state.G2 = 0;
        }

        public void Step()
        {
            // abychom meli stale k dispozici stary stav a vypocet se odrazel vzdy od stareho stavu
            // tj. kdybychom si modifikovali G1 a hned nasledne s nim pracovali, uz bychom staveli na nove hodnote, coz je spatne
            ModelState old = state.DeepClone();

            // v tomto pripade mame dvou-kompartmentovy model
            // kompartmenty: G1 a G2
            // prenos: z G1 do G2 s rychlosti TransferRate1

            state.G1 += -TransferRate1 * old.G1; // z G1 odchazi latka rychlosti TransferRate1
            state.G2 +=  TransferRate1 * old.G1; // z G1 do G2 priteka latka rychlosti TransferRate1
        }
    }
}
