from http.server import SimpleHTTPRequestHandler, HTTPServer

class CustomHandler(SimpleHTTPRequestHandler):
    def end_headers(self):
        self.send_header('Cross-Origin-Embedder-Policy', 'require-corp')
        self.send_header('Cross-Origin-Opener-Policy', 'same-origin')
        super().end_headers()

    def guess_type(self, path):
        # Add MIME type configuration for specific file extensions
        if path.endswith('.wasm'):
            return 'application/wasm'
        else:
            # Call the parent method for other file extensions
            return super().guess_type(path)

if __name__ == '__main__':
    server_address = ('', 8120)
    httpd = HTTPServer(server_address, CustomHandler)
    print('Server running at localhost:8120...')
    httpd.serve_forever()

