/**
 * SmartCGMS - continuous glucose monitoring and controlling framework
 * https://diabetes.zcu.cz/
 *
 * Copyright (c) since 2018 University of West Bohemia.
 *
 * Contact:
 * diabetes@mail.kiv.zcu.cz
 * Medical Informatics, Department of Computer Science and Engineering
 * Faculty of Applied Sciences, University of West Bohemia
 * Univerzitni 8, 301 00 Pilsen
 * Czech Republic
 * 
 * 
 * Purpose of this software:
 * This software is intended to demonstrate work of the diabetes.zcu.cz research
 * group to other scientists, to complement our published papers. It is strictly
 * prohibited to use this software for diagnosis or treatment of any medical condition,
 * without obtaining all required approvals from respective regulatory bodies.
 *
 * Especially, a diabetic patient is warned that unauthorized use of this software
 * may result into severe injure, including death.
 *
 *
 * Licensing terms:
 * Unless required by applicable law or agreed to in writing, software
 * distributed under these license terms is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * a) This file is available under the Apache License, Version 2.0.
 * b) When publishing any derivative work or results obtained using this software, you agree to cite the following paper:
 *    Tomas Koutny and Martin Ubl, "SmartCGMS as a Testbed for a Blood-Glucose Level Prediction and/or 
 *    Control Challenge with (an FDA-Accepted) Diabetic Patient Simulation", Procedia Computer Science,  
 *    Volume 177, pp. 354-362, 2020
 */

#include "pattern_descriptor_model_parameters.h"

/* Copy-paste the following program to e.g.; C++ online compiler to generate the model parameters.
#include <iostream>
#include <sstream>
#include <array>

 
int main() {
	const std::array<std::string, 9> pattern_name = { "accel", "up", "concave",
													  "steady_up", "steady", "steady_down",
													  "convex", "down", "deccel"};

	const size_t bounds_count = 32;

	const char* delim = ", ";
	const char* min_level = "0";
	const char* def_level = "std::numeric_limits<double>::quiet_NaN()";	//nan means repeat the recent level
	const char* max_level = "18";

	const char* prefix = "pattern_model_parameters";
	std::stringstream types, ui_names, config_names, lower, def, upper;

	types << "const scgms::NModel_Parameter_Value model_types[model_param_count] = {";	
	
	ui_names << "const wchar_t* model_param_ui_names[model_param_count] = {";
	config_names << "const wchar_t* model_param_config_names[model_param_count] = {";	

	lower << "const double lower_bound[model_param_count] = {";
	def << "const double default_values[model_param_count] = {";
	upper << "const double upper_bound[model_param_count] = {";

	bool first = true;
	for (size_t pattern_idx = 0; pattern_idx < pattern_name.size(); pattern_idx++) {
		for (size_t band_idx = 0; band_idx < bounds_count; band_idx++) {

			if (!first) {
				types << delim;

				ui_names << delim;
				config_names << delim;				

				lower << delim;
				def << delim;
				upper << delim;
			} 
			first = false;

			types << "scgms::NModel_Parameter_Value::mptDouble";

			ui_names << "L\"" << pattern_name[pattern_idx] << ", band " << std::to_string(band_idx) << "\"";
			config_names << "L\"" << pattern_name[pattern_idx] << "_band_" << std::to_string(band_idx) << "\"";			

			lower << min_level;
			def << def_level;
			upper << max_level;
			
		}
	}

	types << "};";

	ui_names << "};";
	config_names << "};";	

	lower << "};";
	def << "};";
	upper << "};";

	std::cout << "namespace pattern_prediction {" << std::endl;

	std::cout << '\t' << types.str() << std::endl;
	std::cout << '\t' << ui_names.str() << std::endl;
	std::cout << '\t' << config_names.str() << std::endl;
	std::cout << '\t' << lower.str() << std::endl;
	std::cout << '\t' << def.str() << std::endl;
	std::cout << '\t' << upper.str() << std::endl;	

	std::cout << '}' << std::endl;


	return 0;
}

*/

namespace pattern_prediction {

	const scgms::NModel_Parameter_Value model_types[model_param_count] = { scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble, scgms::NModel_Parameter_Value::mptDouble };

	const wchar_t* model_param_ui_names[model_param_count] = { L"accel, band 0", L"accel, band 1", L"accel, band 2", L"accel, band 3", L"accel, band 4", L"accel, band 5", L"accel, band std::numeric_limits<double>::quiet_NaN()", L"accel, band 7", L"accel, band 8", L"accel, band 9", L"accel, band 10", L"accel, band 11", L"accel, band 12", L"accel, band 13", L"accel, band 14", L"accel, band 15", L"accel, band 1std::numeric_limits<double>::quiet_NaN()", L"accel, band 17", L"accel, band 18", L"accel, band 19", L"accel, band 20", L"accel, band 21", L"accel, band 22", L"accel, band 23", L"accel, band 24", L"accel, band 25", L"accel, band 2std::numeric_limits<double>::quiet_NaN()", L"accel, band 27", L"accel, band 28", L"accel, band 29", L"accel, band 30", L"accel, band 31", L"up, band 0", L"up, band 1", L"up, band 2", L"up, band 3", L"up, band 4", L"up, band 5", L"up, band std::numeric_limits<double>::quiet_NaN()", L"up, band 7", L"up, band 8", L"up, band 9", L"up, band 10", L"up, band 11", L"up, band 12", L"up, band 13", L"up, band 14", L"up, band 15", L"up, band 1std::numeric_limits<double>::quiet_NaN()", L"up, band 17", L"up, band 18", L"up, band 19", L"up, band 20", L"up, band 21", L"up, band 22", L"up, band 23", L"up, band 24", L"up, band 25", L"up, band 2std::numeric_limits<double>::quiet_NaN()", L"up, band 27", L"up, band 28", L"up, band 29", L"up, band 30", L"up, band 31", L"concave, band 0", L"concave, band 1", L"concave, band 2", L"concave, band 3", L"concave, band 4", L"concave, band 5", L"concave, band std::numeric_limits<double>::quiet_NaN()", L"concave, band 7", L"concave, band 8", L"concave, band 9", L"concave, band 10", L"concave, band 11", L"concave, band 12", L"concave, band 13", L"concave, band 14", L"concave, band 15", L"concave, band 1std::numeric_limits<double>::quiet_NaN()", L"concave, band 17", L"concave, band 18", L"concave, band 19", L"concave, band 20", L"concave, band 21", L"concave, band 22", L"concave, band 23", L"concave, band 24", L"concave, band 25", L"concave, band 2std::numeric_limits<double>::quiet_NaN()", L"concave, band 27", L"concave, band 28", L"concave, band 29", L"concave, band 30", L"concave, band 31", L"steady_up, band 0", L"steady_up, band 1", L"steady_up, band 2", L"steady_up, band 3", L"steady_up, band 4", L"steady_up, band 5", L"steady_up, band std::numeric_limits<double>::quiet_NaN()", L"steady_up, band 7", L"steady_up, band 8", L"steady_up, band 9", L"steady_up, band 10", L"steady_up, band 11", L"steady_up, band 12", L"steady_up, band 13", L"steady_up, band 14", L"steady_up, band 15", L"steady_up, band 1std::numeric_limits<double>::quiet_NaN()", L"steady_up, band 17", L"steady_up, band 18", L"steady_up, band 19", L"steady_up, band 20", L"steady_up, band 21", L"steady_up, band 22", L"steady_up, band 23", L"steady_up, band 24", L"steady_up, band 25", L"steady_up, band 2std::numeric_limits<double>::quiet_NaN()", L"steady_up, band 27", L"steady_up, band 28", L"steady_up, band 29", L"steady_up, band 30", L"steady_up, band 31", L"steady, band 0", L"steady, band 1", L"steady, band 2", L"steady, band 3", L"steady, band 4", L"steady, band 5", L"steady, band std::numeric_limits<double>::quiet_NaN()", L"steady, band 7", L"steady, band 8", L"steady, band 9", L"steady, band 10", L"steady, band 11", L"steady, band 12", L"steady, band 13", L"steady, band 14", L"steady, band 15", L"steady, band 1std::numeric_limits<double>::quiet_NaN()", L"steady, band 17", L"steady, band 18", L"steady, band 19", L"steady, band 20", L"steady, band 21", L"steady, band 22", L"steady, band 23", L"steady, band 24", L"steady, band 25", L"steady, band 2std::numeric_limits<double>::quiet_NaN()", L"steady, band 27", L"steady, band 28", L"steady, band 29", L"steady, band 30", L"steady, band 31", L"steady_down, band 0", L"steady_down, band 1", L"steady_down, band 2", L"steady_down, band 3", L"steady_down, band 4", L"steady_down, band 5", L"steady_down, band std::numeric_limits<double>::quiet_NaN()", L"steady_down, band 7", L"steady_down, band 8", L"steady_down, band 9", L"steady_down, band 10", L"steady_down, band 11", L"steady_down, band 12", L"steady_down, band 13", L"steady_down, band 14", L"steady_down, band 15", L"steady_down, band 1std::numeric_limits<double>::quiet_NaN()", L"steady_down, band 17", L"steady_down, band 18", L"steady_down, band 19", L"steady_down, band 20", L"steady_down, band 21", L"steady_down, band 22", L"steady_down, band 23", L"steady_down, band 24", L"steady_down, band 25", L"steady_down, band 2std::numeric_limits<double>::quiet_NaN()", L"steady_down, band 27", L"steady_down, band 28", L"steady_down, band 29", L"steady_down, band 30", L"steady_down, band 31", L"convex, band 0", L"convex, band 1", L"convex, band 2", L"convex, band 3", L"convex, band 4", L"convex, band 5", L"convex, band std::numeric_limits<double>::quiet_NaN()", L"convex, band 7", L"convex, band 8", L"convex, band 9", L"convex, band 10", L"convex, band 11", L"convex, band 12", L"convex, band 13", L"convex, band 14", L"convex, band 15", L"convex, band 1std::numeric_limits<double>::quiet_NaN()", L"convex, band 17", L"convex, band 18", L"convex, band 19", L"convex, band 20", L"convex, band 21", L"convex, band 22", L"convex, band 23", L"convex, band 24", L"convex, band 25", L"convex, band 2std::numeric_limits<double>::quiet_NaN()", L"convex, band 27", L"convex, band 28", L"convex, band 29", L"convex, band 30", L"convex, band 31", L"down, band 0", L"down, band 1", L"down, band 2", L"down, band 3", L"down, band 4", L"down, band 5", L"down, band std::numeric_limits<double>::quiet_NaN()", L"down, band 7", L"down, band 8", L"down, band 9", L"down, band 10", L"down, band 11", L"down, band 12", L"down, band 13", L"down, band 14", L"down, band 15", L"down, band 1std::numeric_limits<double>::quiet_NaN()", L"down, band 17", L"down, band 18", L"down, band 19", L"down, band 20", L"down, band 21", L"down, band 22", L"down, band 23", L"down, band 24", L"down, band 25", L"down, band 2std::numeric_limits<double>::quiet_NaN()", L"down, band 27", L"down, band 28", L"down, band 29", L"down, band 30", L"down, band 31", L"deccel, band 0", L"deccel, band 1", L"deccel, band 2", L"deccel, band 3", L"deccel, band 4", L"deccel, band 5", L"deccel, band std::numeric_limits<double>::quiet_NaN()", L"deccel, band 7", L"deccel, band 8", L"deccel, band 9", L"deccel, band 10", L"deccel, band 11", L"deccel, band 12", L"deccel, band 13", L"deccel, band 14", L"deccel, band 15", L"deccel, band 1std::numeric_limits<double>::quiet_NaN()", L"deccel, band 17", L"deccel, band 18", L"deccel, band 19", L"deccel, band 20", L"deccel, band 21", L"deccel, band 22", L"deccel, band 23", L"deccel, band 24", L"deccel, band 25", L"deccel, band 2std::numeric_limits<double>::quiet_NaN()", L"deccel, band 27", L"deccel, band 28", L"deccel, band 29", L"deccel, band 30", L"deccel, band 31" };

	const wchar_t* model_param_config_names[model_param_count] = { L"accel_band_0", L"accel_band_1", L"accel_band_2", L"accel_band_3", L"accel_band_4", L"accel_band_5", L"accel_band_std::numeric_limits<double>::quiet_NaN()", L"accel_band_7", L"accel_band_8", L"accel_band_9", L"accel_band_10", L"accel_band_11", L"accel_band_12", L"accel_band_13", L"accel_band_14", L"accel_band_15", L"accel_band_1std::numeric_limits<double>::quiet_NaN()", L"accel_band_17", L"accel_band_18", L"accel_band_19", L"accel_band_20", L"accel_band_21", L"accel_band_22", L"accel_band_23", L"accel_band_24", L"accel_band_25", L"accel_band_2std::numeric_limits<double>::quiet_NaN()", L"accel_band_27", L"accel_band_28", L"accel_band_29", L"accel_band_30", L"accel_band_31", L"up_band_0", L"up_band_1", L"up_band_2", L"up_band_3", L"up_band_4", L"up_band_5", L"up_band_std::numeric_limits<double>::quiet_NaN()", L"up_band_7", L"up_band_8", L"up_band_9", L"up_band_10", L"up_band_11", L"up_band_12", L"up_band_13", L"up_band_14", L"up_band_15", L"up_band_1std::numeric_limits<double>::quiet_NaN()", L"up_band_17", L"up_band_18", L"up_band_19", L"up_band_20", L"up_band_21", L"up_band_22", L"up_band_23", L"up_band_24", L"up_band_25", L"up_band_2std::numeric_limits<double>::quiet_NaN()", L"up_band_27", L"up_band_28", L"up_band_29", L"up_band_30", L"up_band_31", L"concave_band_0", L"concave_band_1", L"concave_band_2", L"concave_band_3", L"concave_band_4", L"concave_band_5", L"concave_band_std::numeric_limits<double>::quiet_NaN()", L"concave_band_7", L"concave_band_8", L"concave_band_9", L"concave_band_10", L"concave_band_11", L"concave_band_12", L"concave_band_13", L"concave_band_14", L"concave_band_15", L"concave_band_1std::numeric_limits<double>::quiet_NaN()", L"concave_band_17", L"concave_band_18", L"concave_band_19", L"concave_band_20", L"concave_band_21", L"concave_band_22", L"concave_band_23", L"concave_band_24", L"concave_band_25", L"concave_band_2std::numeric_limits<double>::quiet_NaN()", L"concave_band_27", L"concave_band_28", L"concave_band_29", L"concave_band_30", L"concave_band_31", L"steady_up_band_0", L"steady_up_band_1", L"steady_up_band_2", L"steady_up_band_3", L"steady_up_band_4", L"steady_up_band_5", L"steady_up_band_std::numeric_limits<double>::quiet_NaN()", L"steady_up_band_7", L"steady_up_band_8", L"steady_up_band_9", L"steady_up_band_10", L"steady_up_band_11", L"steady_up_band_12", L"steady_up_band_13", L"steady_up_band_14", L"steady_up_band_15", L"steady_up_band_1std::numeric_limits<double>::quiet_NaN()", L"steady_up_band_17", L"steady_up_band_18", L"steady_up_band_19", L"steady_up_band_20", L"steady_up_band_21", L"steady_up_band_22", L"steady_up_band_23", L"steady_up_band_24", L"steady_up_band_25", L"steady_up_band_2std::numeric_limits<double>::quiet_NaN()", L"steady_up_band_27", L"steady_up_band_28", L"steady_up_band_29", L"steady_up_band_30", L"steady_up_band_31", L"steady_band_0", L"steady_band_1", L"steady_band_2", L"steady_band_3", L"steady_band_4", L"steady_band_5", L"steady_band_std::numeric_limits<double>::quiet_NaN()", L"steady_band_7", L"steady_band_8", L"steady_band_9", L"steady_band_10", L"steady_band_11", L"steady_band_12", L"steady_band_13", L"steady_band_14", L"steady_band_15", L"steady_band_1std::numeric_limits<double>::quiet_NaN()", L"steady_band_17", L"steady_band_18", L"steady_band_19", L"steady_band_20", L"steady_band_21", L"steady_band_22", L"steady_band_23", L"steady_band_24", L"steady_band_25", L"steady_band_2std::numeric_limits<double>::quiet_NaN()", L"steady_band_27", L"steady_band_28", L"steady_band_29", L"steady_band_30", L"steady_band_31", L"steady_down_band_0", L"steady_down_band_1", L"steady_down_band_2", L"steady_down_band_3", L"steady_down_band_4", L"steady_down_band_5", L"steady_down_band_std::numeric_limits<double>::quiet_NaN()", L"steady_down_band_7", L"steady_down_band_8", L"steady_down_band_9", L"steady_down_band_10", L"steady_down_band_11", L"steady_down_band_12", L"steady_down_band_13", L"steady_down_band_14", L"steady_down_band_15", L"steady_down_band_1std::numeric_limits<double>::quiet_NaN()", L"steady_down_band_17", L"steady_down_band_18", L"steady_down_band_19", L"steady_down_band_20", L"steady_down_band_21", L"steady_down_band_22", L"steady_down_band_23", L"steady_down_band_24", L"steady_down_band_25", L"steady_down_band_2std::numeric_limits<double>::quiet_NaN()", L"steady_down_band_27", L"steady_down_band_28", L"steady_down_band_29", L"steady_down_band_30", L"steady_down_band_31", L"convex_band_0", L"convex_band_1", L"convex_band_2", L"convex_band_3", L"convex_band_4", L"convex_band_5", L"convex_band_std::numeric_limits<double>::quiet_NaN()", L"convex_band_7", L"convex_band_8", L"convex_band_9", L"convex_band_10", L"convex_band_11", L"convex_band_12", L"convex_band_13", L"convex_band_14", L"convex_band_15", L"convex_band_1std::numeric_limits<double>::quiet_NaN()", L"convex_band_17", L"convex_band_18", L"convex_band_19", L"convex_band_20", L"convex_band_21", L"convex_band_22", L"convex_band_23", L"convex_band_24", L"convex_band_25", L"convex_band_2std::numeric_limits<double>::quiet_NaN()", L"convex_band_27", L"convex_band_28", L"convex_band_29", L"convex_band_30", L"convex_band_31", L"down_band_0", L"down_band_1", L"down_band_2", L"down_band_3", L"down_band_4", L"down_band_5", L"down_band_std::numeric_limits<double>::quiet_NaN()", L"down_band_7", L"down_band_8", L"down_band_9", L"down_band_10", L"down_band_11", L"down_band_12", L"down_band_13", L"down_band_14", L"down_band_15", L"down_band_1std::numeric_limits<double>::quiet_NaN()", L"down_band_17", L"down_band_18", L"down_band_19", L"down_band_20", L"down_band_21", L"down_band_22", L"down_band_23", L"down_band_24", L"down_band_25", L"down_band_2std::numeric_limits<double>::quiet_NaN()", L"down_band_27", L"down_band_28", L"down_band_29", L"down_band_30", L"down_band_31", L"deccel_band_0", L"deccel_band_1", L"deccel_band_2", L"deccel_band_3", L"deccel_band_4", L"deccel_band_5", L"deccel_band_std::numeric_limits<double>::quiet_NaN()", L"deccel_band_7", L"deccel_band_8", L"deccel_band_9", L"deccel_band_10", L"deccel_band_11", L"deccel_band_12", L"deccel_band_13", L"deccel_band_14", L"deccel_band_15", L"deccel_band_1std::numeric_limits<double>::quiet_NaN()", L"deccel_band_17", L"deccel_band_18", L"deccel_band_19", L"deccel_band_20", L"deccel_band_21", L"deccel_band_22", L"deccel_band_23", L"deccel_band_24", L"deccel_band_25", L"deccel_band_2std::numeric_limits<double>::quiet_NaN()", L"deccel_band_27", L"deccel_band_28", L"deccel_band_29", L"deccel_band_30", L"deccel_band_31" };

	const double lower_bound[model_param_count] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

	const double default_values[model_param_count] = { std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN(), std::numeric_limits<double>::quiet_NaN() };

	const double upper_bound[model_param_count] = { 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18 };

}
