#pragma once
#include <filters/filter_chain/data_filter/src/descriptor.h>
#include <filters/filter_chain/ema_filter/src/descriptor.h>
#include <filters/filter_chain/watchdog_filter/src/descriptor.h>
#include <filters/filter_chain/print_filter/src/descriptor.h>
#include <filters/filter_chain/signal/src/descriptor.h>
#include <filters/models/discrete_model/src/descriptor.h>
#include <scgms/iface/UIIface.h>

class MyCloaded_Filters
{
protected:
    std::vector<scgms::TFilter_Descriptor> mFilter_Descriptors;

public:
    MyCloaded_Filters();
    void load_descriptors();
    HRESULT get_filter_descriptors_body(scgms::TFilter_Descriptor **begin, scgms::TFilter_Descriptor **end);
};

HRESULT get_all_descriptors(scgms::TFilter_Descriptor **begin, scgms::TFilter_Descriptor **end);
scgms::SFilter create_filter_body_(const GUID &id, scgms::IFilter *next_filter);
void describe_loaded_filters_(refcnt::Swstr_list error_description);

HRESULT do_get_model_descriptors_(scgms::TSignal_Descriptor **begin, scgms::TSignal_Descriptor **end);
HRESULT do_get_signal_descriptors_(scgms::TSignal_Descriptor **begin, scgms::TSignal_Descriptor **end);
HRESULT do_create_discrete_model_(const GUID *model_id, scgms::IModel_Parameter_Vector *parameters, scgms::IFilter *output, scgms::IDiscrete_Model **model);

void* resolve_generated_symbol(const char *symbol_name) noexcept;