/**
 * SmartCGMS - continuous glucose monitoring and controlling framework
 * https://diabetes.zcu.cz/
 *
 * Copyright (c) since 2018 University of West Bohemia.
 *
 * Contact:
 * diabetes@mail.kiv.zcu.cz
 * Medical Informatics, Department of Computer Science and Engineering
 * Faculty of Applied Sciences, University of West Bohemia
 * Univerzitni 8, 301 00 Pilsen
 * Czech Republic
 * 
 * 
 * Purpose of this software:
 * This software is intended to demonstrate work of the diabetes.zcu.cz research
 * group to other scientists, to complement our published papers. It is strictly
 * prohibited to use this software for diagnosis or treatment of any medical condition,
 * without obtaining all required approvals from respective regulatory bodies.
 *
 * Especially, a diabetic patient is warned that unauthorized use of this software
 * may result into severe injure, including death.
 *
 *
 * Licensing terms:
 * Unless required by applicable law or agreed to in writing, software
 * distributed under these license terms is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * a) This file is available under the Apache License, Version 2.0.
 * b) When publishing any derivative work or results obtained using this software, you agree to cite the following paper:
 *    Tomas Koutny and Martin Ubl, "SmartCGMS as a Testbed for a Blood-Glucose Level Prediction and/or 
 *    Control Challenge with (an FDA-Accepted) Diabetic Patient Simulation", Procedia Computer Science,  
 *    Volume 177, pp. 354-362, 2020
 */

#include "DeviceIface.h"



namespace scgms {

	const std::array<GUID, 100> signal_Virtual{ {
			{ 0xd4ddb8c4, 0xe48c, 0x4757,{ 0xbf, 0xe6, 0x26, 0x15, 0xc5, 0x79, 0x8f, 0xd3 } },
			{ 0x1a3254af, 0x8430, 0x426c,{ 0xa1, 0x21, 0x7d, 0xbc, 0xe7, 0x9d, 0x6a, 0x30 } },
			{ 0xc17484ea, 0xed29, 0x47bd,{ 0x92, 0xb2, 0x4d, 0xfa, 0x8a, 0xc4, 0x1d, 0x59 } },
			{ 0x13356e3c, 0x1b34, 0x4de8,{ 0xaa, 0xc1, 0xe4, 0x84, 0x3e, 0xbf, 0xaa, 0x1f } },
			{ 0x2ba2f7cf, 0xae9b, 0x46c9,{ 0x83, 0x48, 0x8f, 0x7b, 0x56, 0xfe, 0x0d, 0x3f } },
			{ 0xc4170548, 0xf817, 0x4bb8,{ 0x9b, 0xd5, 0x34, 0x46, 0x6c, 0xe0, 0xc0, 0xbd } },
			{ 0x8f88b3fb, 0x481d, 0x465c,{ 0xb1, 0x2f, 0x4e, 0xf8, 0x30, 0xd0, 0x8f, 0x05 } },
			{ 0x01df3eb0, 0x045e, 0x42e7,{ 0x99, 0xe5, 0x2e, 0x78, 0x5a, 0x2c, 0x06, 0x54 } },
			{ 0xd4e5873e, 0x1ff4, 0x4bbc,{ 0x8f, 0xf9, 0x92, 0x65, 0x2a, 0x90, 0x66, 0x7a } },
			{ 0x04ec5a48, 0x320e, 0x4105,{ 0xbe, 0x25, 0x2e, 0x36, 0x03, 0xf7, 0x2a, 0x77 } },
			{ 0xb24fc613, 0x3376, 0x4993,{ 0x8e, 0x0d, 0xf0, 0x3d, 0x53, 0x2c, 0x7b, 0x3d } },
			{ 0xc902e58b, 0xe1b2, 0x4dbb,{ 0x93, 0x95, 0xaf, 0x3f, 0xf6, 0xf9, 0xe0, 0x9f } },
			{ 0x2d061fcc, 0xaa6c, 0x4610,{ 0xa1, 0xee, 0x6c, 0x5b, 0xa1, 0xf7, 0x49, 0x3d } },
			{ 0x6f5c2801, 0x8773, 0x4821,{ 0xb5, 0xb0, 0x29, 0x25, 0x1f, 0xe1, 0xae, 0x01 } },
			{ 0x0ab4880b, 0x9b5e, 0x4f23,{ 0xb7, 0x40, 0xbc, 0x3d, 0x01, 0x2e, 0x79, 0x30 } },
			{ 0xa3f680c3, 0x7136, 0x434f,{ 0x96, 0xea, 0x7d, 0x58, 0x6a, 0x97, 0x05, 0x85 } },
			{ 0x4eb2ecf2, 0x267f, 0x4947,{ 0xbf, 0x5a, 0x7d, 0x94, 0x3f, 0xe1, 0xc4, 0xd8 } },
			{ 0xfb4672a4, 0xf3e0, 0x4a98,{ 0xa6, 0x6a, 0x68, 0xa3, 0x4a, 0x4b, 0x85, 0x74 } },
			{ 0xed9ac348, 0x6eb2, 0x4647,{ 0xa0, 0x1a, 0x30, 0xad, 0xc9, 0x4b, 0xb6, 0xa9 } },
			{ 0x7f50b856, 0xd064, 0x4538,{ 0xbb, 0x08, 0xc1, 0x92, 0x29, 0xde, 0x6f, 0x5c } },
			{ 0x21aa11af, 0x041a, 0x4518,{ 0xac, 0x3e, 0x2a, 0x1a, 0xf5, 0x4f, 0x08, 0xf3 } },
			{ 0xa5f27c71, 0x8aed, 0x42bc,{ 0x8c, 0x06, 0xf4, 0x21, 0x9b, 0x47, 0x4b, 0xfb } },
			{ 0x2fe7d29c, 0x36da, 0x4cba,{ 0xbb, 0x60, 0xaa, 0x64, 0x50, 0x7c, 0x85, 0xf9 } },
			{ 0x3cd392b0, 0xcaa1, 0x4600,{ 0xb5, 0x95, 0x64, 0x4b, 0x4a, 0xb3, 0x09, 0xc5 } },
			{ 0xd208d043, 0x5afb, 0x4efe,{ 0x89, 0xbe, 0x4d, 0x75, 0x8d, 0xa6, 0x01, 0x8c } },
			{ 0xf736fe34, 0xa54f, 0x429a,{ 0x99, 0xb6, 0x08, 0xcf, 0x75, 0x93, 0x47, 0x98 } },
			{ 0xb95730ff, 0x9bf2, 0x469f,{ 0xb8, 0xe3, 0x3e, 0x39, 0xbb, 0x7e, 0x10, 0xe4 } },
			{ 0xb854b5b3, 0x819f, 0x4edb,{ 0xa7, 0x35, 0xa3, 0x97, 0xea, 0xdf, 0xa7, 0x2a } },
			{ 0x36f569ec, 0x957b, 0x4649,{ 0xa8, 0x83, 0xb8, 0x4a, 0x2f, 0x0b, 0x6c, 0x62 } },
			{ 0x228b55ac, 0x8b1c, 0x4403,{ 0xa4, 0xcf, 0xef, 0xff, 0x10, 0x03, 0x74, 0xe9 } },
			{ 0x1c9cf1a3, 0x83a9, 0x4da5,{ 0xba, 0x48, 0xb5, 0x7b, 0x9e, 0x57, 0x18, 0xbd } },
			{ 0x386240a3, 0x99d4, 0x46d0,{ 0x98, 0x25, 0xa6, 0x80, 0xa5, 0x55, 0x7f, 0xbc } },
			{ 0x83ea8839, 0x058c, 0x4b22,{ 0xb3, 0xa3, 0xec, 0x0e, 0x97, 0x48, 0xe1, 0x0d } },
			{ 0x479736e5, 0x5050, 0x4da1,{ 0x87, 0x19, 0x47, 0x6f, 0xf0, 0xb6, 0xce, 0xbb } },
			{ 0xb7da5732, 0xb653, 0x43a7,{ 0x97, 0x2e, 0xfa, 0xf8, 0x72, 0xc7, 0x15, 0x6f } },
			{ 0x94abfebf, 0x4ce7, 0x4b69,{ 0xa3, 0x26, 0xd0, 0xff, 0x4a, 0x1e, 0xcd, 0xfd } },
			{ 0xfb8caa70, 0x6ee2, 0x47a0,{ 0xb7, 0x7c, 0x23, 0x3d, 0x18, 0xed, 0x52, 0x97 } },
			{ 0xbfa0451a, 0x5354, 0x4895,{ 0x8e, 0x35, 0xc2, 0x8e, 0x84, 0x3d, 0x57, 0xe9 } },
			{ 0x76d9c4c7, 0xed41, 0x4a7b,{ 0x9d, 0x8a, 0xc9, 0xdd, 0x36, 0x3b, 0xac, 0xac } },
			{ 0x445876f2, 0x4b2a, 0x4a5c,{ 0x80, 0x00, 0xd9, 0x7b, 0xef, 0xdd, 0xbe, 0x58 } },
			{ 0x3c75b314, 0x5d64, 0x4e81,{ 0xa7, 0x9e, 0xb6, 0x75, 0x17, 0xfb, 0x51, 0x81 } },
			{ 0xc201590d, 0x2b5c, 0x4a9e,{ 0x87, 0x6a, 0xec, 0xbf, 0x3b, 0x05, 0xb5, 0x60 } },
			{ 0x0b950e07, 0x9393, 0x4fb9,{ 0xa7, 0x27, 0x83, 0x7b, 0x6e, 0xd0, 0x9d, 0xc4 } },
			{ 0x5cd6b756, 0xf57a, 0x4299,{ 0xa5, 0xd4, 0xe2, 0x71, 0xca, 0x96, 0x31, 0xfb } },
			{ 0x987b2a6a, 0xeee4, 0x4236,{ 0xb5, 0x81, 0x5c, 0x25, 0x4f, 0x2a, 0xc5, 0x86 } },
			{ 0x217af397, 0x4061, 0x49a2,{ 0xac, 0x55, 0x5e, 0xac, 0x09, 0xd3, 0x71, 0x71 } },
			{ 0x65d1a85d, 0x1812, 0x4cfe,{ 0x83, 0x3d, 0xbd, 0x29, 0x8d, 0xbe, 0xce, 0x18 } },
			{ 0x06640e2f, 0x5d4c, 0x4e8b,{ 0xb3, 0x13, 0x81, 0x12, 0x9e, 0xc4, 0x8d, 0x13 } },
			{ 0x6a6e8703, 0x02e4, 0x4d96,{ 0xb6, 0x67, 0x49, 0x79, 0xde, 0x38, 0x20, 0x65 } },
			{ 0x644aecd6, 0xb7a4, 0x418a,{ 0xb5, 0x42, 0xbc, 0x0e, 0xc6, 0xa9, 0x89, 0xf0 } },
			{ 0x630795c4, 0x5f07, 0x4c51,{ 0x88, 0x47, 0x12, 0xb0, 0x22, 0x16, 0xf8, 0xc7 } },
			{ 0x7d9b907b, 0x988c, 0x41b0,{ 0x84, 0x23, 0x6e, 0x01, 0xdc, 0x90, 0x49, 0xd3 } },
			{ 0xb8edfe9a, 0xddbf, 0x49c9,{ 0xb0, 0xc6, 0xa0, 0x59, 0x47, 0xad, 0x4c, 0xaa } },
			{ 0x2266fc1c, 0xd0d9, 0x465b,{ 0xb7, 0x18, 0xaf, 0xda, 0xa5, 0x5a, 0x5e, 0x62 } },
			{ 0xe1efae1a, 0xd44c, 0x49e2,{ 0xa0, 0xda, 0xdb, 0x62, 0x4f, 0x17, 0x0d, 0x35 } },
			{ 0x800cb25a, 0x7d2c, 0x44fc,{ 0xb0, 0x96, 0x17, 0x8e, 0x90, 0x76, 0x08, 0xd0 } },
			{ 0x39c6f02f, 0x1444, 0x47cd,{ 0xae, 0x5f, 0x16, 0x56, 0x01, 0xf7, 0x03, 0x7e } },
			{ 0xb445ecd4, 0xecba, 0x464b,{ 0xa1, 0x0c, 0x0f, 0xf1, 0x13, 0xe4, 0x03, 0x87 } },
			{ 0x6439830b, 0x57a6, 0x4132,{ 0xba, 0x9f, 0x72, 0xcb, 0x57, 0xab, 0xef, 0x99 } },
			{ 0xbcf46803, 0xa1dc, 0x47bc,{ 0x87, 0xb8, 0x27, 0x53, 0xd4, 0x75, 0x83, 0xa4 } },
			{ 0x62597022, 0x8cbd, 0x40e9,{ 0xb8, 0xf9, 0xcd, 0xf5, 0xb0, 0xc6, 0x97, 0x12 } },
			{ 0x15489c44, 0x08c3, 0x46cb,{ 0x8d, 0x7f, 0xd1, 0x6d, 0x31, 0xdb, 0xa4, 0x49 } },
			{ 0xca0234d6, 0x42b9, 0x4d19,{ 0xae, 0x0b, 0x47, 0xa5, 0xc6, 0xd5, 0x47, 0x87 } },
			{ 0xbdaba2a9, 0x2ecb, 0x4ce2,{ 0x9b, 0x3d, 0xa9, 0xaa, 0xcb, 0xbd, 0x38, 0xcf } },
			{ 0x4d20b051, 0x7c62, 0x4240,{ 0x85, 0x04, 0xae, 0xb3, 0xd4, 0xdd, 0x28, 0x13 } },
			{ 0xb736e996, 0xa556, 0x4c85,{ 0x94, 0x74, 0x3b, 0xa3, 0xce, 0x44, 0x25, 0x78 } },
			{ 0x502a3a0c, 0xc858, 0x4e48,{ 0xbf, 0x9e, 0xca, 0xfb, 0xeb, 0x04, 0x7e, 0x81 } },
			{ 0xf1fedc9d, 0xf1a5, 0x4ade,{ 0xaa, 0x2c, 0xc2, 0x17, 0x55, 0x36, 0x09, 0x48 } },
			{ 0x0c2b7f00, 0x2770, 0x41d1,{ 0x82, 0x8b, 0x34, 0xcb, 0x0b, 0xbd, 0x34, 0x2e } },
			{ 0x6032f662, 0xcceb, 0x4a73,{ 0x85, 0x06, 0xda, 0x7d, 0xef, 0xde, 0x43, 0x45 } },
			{ 0x0f1671bf, 0x5e16, 0x4d27,{ 0x8a, 0xa0, 0x96, 0x55, 0x5f, 0x76, 0xd6, 0x83 } },
			{ 0xd45857e5, 0xbca1, 0x462e,{ 0xbe, 0xaf, 0xe5, 0x3c, 0x82, 0x5b, 0x9e, 0x82 } },
			{ 0x3a32ee0c, 0xa201, 0x4bb1,{ 0x89, 0x47, 0xbd, 0x2d, 0x8b, 0x86, 0xab, 0xbc } },
			{ 0x30a786d5, 0x089c, 0x42be,{ 0xb1, 0xad, 0xe9, 0x98, 0x0c, 0xb8, 0x96, 0x94 } },
			{ 0xd6d68eb0, 0xdf9a, 0x41cd,{ 0x89, 0x56, 0xa7, 0x7e, 0xc4, 0x85, 0x0d, 0x5b } },
			{ 0x8b290879, 0x37a6, 0x4706,{ 0x8d, 0x7e, 0x56, 0x9e, 0x4f, 0xbe, 0x93, 0xf2 } },
			{ 0xed1f41c3, 0xbf81, 0x4e2c,{ 0x83, 0x73, 0x63, 0xa7, 0x0f, 0x5a, 0xf4, 0x64 } },
			{ 0xef5284f0, 0xb400, 0x4a82,{ 0xac, 0x54, 0xdc, 0xc6, 0x3a, 0x77, 0x95, 0x1a } },
			{ 0x327c40a8, 0xaa84, 0x4e32,{ 0xb3, 0x19, 0x77, 0x7e, 0xb7, 0x53, 0x62, 0x4b } },
			{ 0x2716174c, 0xa099, 0x46e5,{ 0xbe, 0x6a, 0xff, 0x6a, 0x10, 0x9e, 0xff, 0xa1 } },
			{ 0x445c854a, 0xfe35, 0x4a59,{ 0x96, 0x07, 0xb2, 0x08, 0x9e, 0x3d, 0xf6, 0xa8 } },
			{ 0xee09d419, 0x84a2, 0x402a,{ 0xbb, 0x80, 0x3b, 0xbd, 0x95, 0x3f, 0x1e, 0x0c } },
			{ 0x365ec968, 0x0cde, 0x4b02,{ 0xa8, 0xef, 0x64, 0x47, 0xf3, 0x28, 0xbe, 0x2c } },
			{ 0x636c482a, 0xdea4, 0x4d38,{ 0xae, 0x08, 0x54, 0x62, 0x7f, 0x0a, 0xb5, 0xb2 } },
			{ 0xe8e29546, 0xf9f2, 0x47a5,{ 0xb2, 0xbf, 0xf4, 0x67, 0x6c, 0xd6, 0x52, 0xf8 } },
			{ 0x2facb174, 0x798d, 0x4e38,{ 0x93, 0xcd, 0x46, 0x23, 0x9a, 0x7d, 0x6a, 0x32 } },
			{ 0xff5ff1e0, 0x327a, 0x429d,{ 0x91, 0x6f, 0x00, 0x54, 0xed, 0xfb, 0xfb, 0x19 } },
			{ 0xb13829ec, 0xf82f, 0x47e6,{ 0xb5, 0x40, 0xa1, 0x2f, 0xfd, 0x1e, 0x28, 0x8a } },
			{ 0x078b1fd4, 0x422d, 0x404f,{ 0xbd, 0xcf, 0x49, 0x58, 0x2b, 0x9f, 0xb0, 0x40 } },
			{ 0xd8d6ad7e, 0x1846, 0x4e40,{ 0xbf, 0xc3, 0x5e, 0x3c, 0x5c, 0x92, 0xb2, 0xe0 } },
			{ 0x1fa03911, 0xa62d, 0x4ecf,{ 0xaf, 0xe8, 0x60, 0xb8, 0x37, 0x91, 0x51, 0xb8 } },
			{ 0x56c37af2, 0xfa68, 0x43ef,{ 0x88, 0xb6, 0x8e, 0xa2, 0x8e, 0x95, 0x78, 0x24 } },
			{ 0xe959b878, 0x74e4, 0x479f,{ 0xae, 0xce, 0x7a, 0xf2, 0xf1, 0x45, 0x44, 0x98 } },
			{ 0xb6c0caa3, 0x01a3, 0x402d,{ 0x82, 0x3d, 0x57, 0xff, 0x8f, 0x2d, 0x9c, 0x45 } },
			{ 0x173ffbb1, 0x51bc, 0x4e9b,{ 0x91, 0x19, 0x5b, 0x95, 0xee, 0xd2, 0x90, 0x42 } },
			{ 0xbbe13567, 0xc1f8, 0x489d,{ 0x84, 0x16, 0xab, 0x35, 0x65, 0xde, 0x4f, 0x67 } },
			{ 0xc480dff2, 0xae70, 0x4dbb,{ 0xa7, 0xf6, 0xe9, 0x7d, 0xa3, 0xf0, 0xdd, 0x8e } },
			{ 0x834d48b7, 0x57f5, 0x4277,{ 0x98, 0xb6, 0x49, 0x03, 0x03, 0xe2, 0x6c, 0xa9 } },
			{ 0x1f30c0fa, 0x7977, 0x4ca1,{ 0x86, 0xe8, 0x2c, 0xb4, 0x6c, 0x5e, 0xc3, 0x97 } },
			{ 0x79edf100, 0xb0a2, 0x4ee7,{ 0xab, 0x17, 0x16, 0x37, 0x41, 0x8d, 0xb1, 0x5a } }
		}  };

}