#include "smartcgms_sources/scgms.h"
#include <emscripten.h>
#include <string>

extern "C" {
EMSCRIPTEN_KEEPALIVE
void push_event(int level)
{
    SCGMSConcept_Event_Data event;
    memset(&event, 0, sizeof(event));
    event.event_code = 2;	//Level
    event.level = level;
    create_event(&event);
}
}

extern "C" {
EMSCRIPTEN_KEEPALIVE
void shutdown()
{
    SCGMSConcept_Event_Data event;
    memset(&event, 0, sizeof(event));
    event.event_code = 1;	//Shut Down
    create_event(&event);
}
}

extern "C" {
EMSCRIPTEN_KEEPALIVE
const char* get_config()
{
    return get_config_data();
}
}

extern "C" {
EMSCRIPTEN_KEEPALIVE
void build_chain(const char* conf)
{
    shutdown();
    if(strcmp(conf,"") == 0)
    {
        build_filter_chain(nullptr);
    }
    else
    {
        build_filter_chain(conf);
    }
}
}

int main()
{
}