<?php

declare(strict_types=1);

namespace App\Core;

use Nette;
use Nette\Application\Routers\RouteList;


final class RouterFactory
{
	use Nette\StaticClass;

	public static function createRouter(): RouteList
	{
		$router = new RouteList;

        $router->addRoute('api/profile/uploadprofileimage', "Profile:uploadprofileimg");
        $router->addRoute('api/profile/getprofileimage/<userId>', "Profile:getprofileimg");
        $router->addRoute('api/profile/updatesettings', "Profile:updateusersettings");

        $router->addRoute('api/user/login', "User:login");
        $router->addRoute('api/user/getuser', "User:getuser");
        $router->addRoute('api/user/register', "User:register");
        $router->addRoute('api/user/logout', "User:logout");
        $router->addRoute('api/user/changepassword', "User:changepassword");

        $router->addRoute('api/comments/add', "Comment:add");
        $router->addRoute('api/comments/rate/<commentId>', "Comment:rate");

        $router->addRoute('api/articles/topics', "Articles:gettopics");
        $router->addRoute('api/articles/all[/<page=1>]', "Articles:publicarticles");
        $router->addRoute('api/articles/self[/<page=1>]', "Articles:getselfarticles");
        $router->addRoute('api/articles/latest', "Articles:getpostslatest");
        $router->addRoute('api/articles/recommended', "Articles:getpostslatest"); //TODO
        $router->addRoute('api/articles/favorite', "Articles:getpostslatest"); // TODO
        $router->addRoute('api/articles/opened', "Articles:opened");
        $router->addRoute('api/articles/article/<articleId>', "Articles:getarticle");
        $router->addRoute('api/articles/download/<articleId>/<fileId>', "Articles:getfile");

        $router->addRoute('api/editor/all[/<page=1>]', "Articles:allarticles");
        $router->addRoute('api/editor/article/<articleId>', "Editor:getarticle");
        $router->addRoute('api/editor/createarticle', "Editor:createarticle");
        $router->addRoute('api/editor/updatearticle/<articleId>', "Editor:updatearticle");
        $router->addRoute('api/editor/setarticlestatus/<articleId>/<newStatus>', "Editor:setarticlestatus");
        $router->addRoute('api/editor/uploadfiles/[<articleId>]', "Editor:uploadarticlefiles");
        $router->addRoute('api/editor/<newStatus>', "Editor:setarticlesstatus");


		$router->addRoute('<presenter>/<action>[/<id>]', 'Home:default');
		return $router;
	}
}
