<?php

namespace App\Presentation;

use Nette;
use Nette\Database\Table\Selection;

class BasePresenter extends Nette\Application\UI\Presenter
{

    function startup(): void
    {
        parent::startup();
        $session = $this->getSession();
        $session->setCookieParameters(
            path: '/',
            domain: null,
            secure: true,
            sameSite: 'None'
        );
    }

    function beforeRender(): void
    {
        parent::beforeRender();

    }

    /**
     * Pokud je poslan pozadavek pres POST jako JSON, toto overi, jestli je pozadavek validni
     * a data vrati jako pole. Pokud pozadavek neni platny, ukonci request s nalezitou chybou
     *
     * @param array $requiredValues Seznam pozadovanych vstupnich hodnot
     * @return mixed Vystupni validni hodnoty
     */
    function getPayloadJsonAndCheckRequest(array $requiredValues = []): mixed
    {
        $request = $this->getHttpRequest();

        if ($request->getMethod() !== 'POST') {
            $this->error('Method Not Allowed', 405);
        }

        if (!str_contains((string)$request->getHeader('Content-Type'), 'application/json')) {
            $this->error('Unsupported Media Type', 415);
        }

        $payload = json_decode($request->getRawBody(), true);

        if (!is_array($payload)) {
            $this->error('Bad Request', 400);
        }

        foreach ($requiredValues as $value) {
            if (!isset($payload[$value])) {
                $this->error('Bad Request', 400);
            }
        }
        return $payload;
    }


    function getUploadedFilesAndCheckRequest(): array
    {
        $request = $this->getHttpRequest();

        if ($request->getMethod() !== 'POST') {
            $this->error('Method Not Allowed', 405);
        }

        if (!str_contains((string)$request->getHeader('Content-Type'), 'multipart/form-data')) {
            $this->error('Unsupported Media Type', 415);
        }

        $files = $request->getFiles();

        if (sizeof($files) == 0) {
            $this->error('Bad Request: No files were uploaded.', 400);
        }

        return $files;
    }

    /**
     * Funkce prida pole dat do pripravovaneho vystupu
     *
     * @param $output array Pole, do ktereho budou data nacitany
     * @param $database_object Selection Objekt nacteny z databaze
     * @param $display_parameters array Parametry, ktere se maji pridat
     * @return void
     */
    function prepareObjectsOutput(array &$output, Selection $database_object, array $display_parameters): void
    {
        foreach ($database_object as $item) {
            $item_output = [];
            foreach ($display_parameters as $parameter) {
                $item_output[$parameter] = $item[$parameter];
            }
            $output[] = $item_output;
        }
    }

    function prepareObjectOutput(array &$output, Selection $database_object, array $display_parameters): void
    {
        foreach ($database_object as $item) {
            foreach ($display_parameters as $parameter) {
                $output[$parameter] = $item[$parameter];
            }
        }
    }
}