# Endpointy:

## Příspěvky
- api/articles/all/\<cislo stranky>
  - Vrátí všechny příspěvky pro zadanou stránku
  - Číslo stránky
  - Celkový počet stránek
  - Celkový počet příspěvků
  - Pole náhledů příspěvků
    - id
    - title
    - type
    - short_description
    - time_estimate
    - difficulty
    - usage_count
    - created_at
    - updated_at
  - Ukázka
    - ```json
      {"page":1,"pages_count":1,"articles_count":2,"articles":[{"id":2,"title":"Goniometrické funkce","type":"fyzická","short_description":"Článek o goniometrických funkcích","time_estimate":20,"difficulty":"lehké","usage_count":20,"created_at":"2025-04-09T09:28:18+02:00","last_change":null},{"id":3,"title":"Lineární funkce","type":"fyzická","short_description":"Článek o linárních funkcích","time_estimate":20,"difficulty":"lehké","usage_count":20,"created_at":"2025-04-09T09:28:18+02:00","last_change":null}]}
      ```

- api/articles/self/<cislo stranky>      
  - Vrati vsechny clanky od prihlaseneho uzivatele
  - Data maji stejnou strukturu jako endpoint articles/all, je doplněna položka status


- api/articles/article/\<id příspěvku>
  - Vrátí data o článku se zadaným ID
  - Jedna hodnota
    - title
    - type
    - short_description
    - content
    - time_estimate
    - difficulty
    - usage_count
    - created_at
    - comments (pole hodnot)
      - id
      - parent_comments_id
      - text
      - author
      - created_at
      - child_comments
        - komentare odpovidajici na tento
    - files
      - id
      - name
    - Ukázka
      - ```json
        {"title":"Goniometrické funkce","type":"digitální","short_description":"Článek o goniometrických funkcích","content":"Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum","time_estimate":20,"difficulty":"lehké","usage_count":20,"created_at":"2025-04-09T09:28:18+02:00","comments":[{"id":1,"parent_comments_id":null,"text":"Super článek!","author":"amos","created_at":"2025-04-16T09:25:22+02:00","child_comments":[{"id":2,"parent_comments_id":1,"text":"Moc díky!","author":"amos","created_at":"2025-04-16T11:10:43+02:00","child_comments":[]}]}]}
        ```
        
- api/articles/download<id příspěvku>/<id souboru>
  - Vrátí jako odpověď soubor nahraný k příspěvku
    
- api/articles/latest
  - Vrátí poslední přidané články (max 5)
  - Pole hodnot
    - ID
    - title
    - type
    - short_description
    - time_estimate
    - difficulty
    - usage_count
    - created_at
    - last_change
  - Ukázka
      - ```json
         [{"id":2,"title":"Goniometrické funkce","type":"digitální","short_description":"Článek o goniometrických funkcích","time_estimate":20,"difficulty":"lehké","usage_count":20,"created_at":"2025-04-09T09:28:18+02:00","last_change":null}]
        ```
- api/articles/opened
  - Vrátí naposledy otevřené příspěvky (max 5)
  - Data jsou stejná jako v endpointu latest


- api/articles/topics
  - Vrátí seznam nearchivovaných témat
  - Pole hodnot
    - topic
      - subtopics
  - Ukázka
    - ```json
      {"ARGUMENTACE A OVĚŘOVÁNÍ": ["základní poznatky z matematiky", "množiny", "výroková logika"],"ČÍSLO A PROMĚNNÁ": ["číselné obory", "mocniny", "výrazy s proměnnými", "rovnice a nerovnice"]}
      ```

## Editor
- api/editor/createarticle
  - Vytvoří nový příspěvek v databázi
  - Nutné oprávnění
    - article->create
  - Vstup (POST) JSON
    - title
    - type (fyzicka/digitalni)
    - short_description
    - content
    - time_estimate
    - difficulty (lehka/stredni/obtizna)
    - topic_id
  - Výstup pole hodnot
    - success (true)
    - articleId

- api/editor/updatearticle/\<id příspěvku>
  - Upraví existující příspěvek v databázi
  - Nutné oprávnění
    - article->edit-self (pro vlastní články)
    - article->edit-all (pro jakýkoliv článek článk)
  - Vstup (POST) JSON
    - title
    - type (fyzicka/digitalni)
    - short_description
    - content
    - time_estimate
    - difficulty (lehka/stredni/obtizna)
    - topic_id

- api/editor/setarticlestatus/\<id příspěvku>/\<status>
  - Upraví status existujícímu článku
  - Nutné oprávnění
    - article->approve (pro nastavení statusu APPROVED, REJECTED)
    - article->edit-self (pro nastavení statusu TO_CHECK pokud jsem autorem) NEBO:
    - article->edit (pro nastavení statusu TO_CHECK)

- api/editor/uploadfiles/<id příspěvku>
  - Nahraje soubor k vytvořenému příspěvku 
  - Vstup (POST) JSON
    - Soubory pro nahrání (pod libovolným označením)

## Komentář
- api/comments/add
  - Přidat komentář
  - Vstup (POST) JSON
    - article_id
    - parent_comment_id (může být null pokud nemá nadřazený komentář)
    - text

## Uživatel
- api/user/getuser
  - Vrátí data o přihlášeném uživateli nebo informaci o tom, že uživatel přihlášený není
  - Pole hodnot
    - status (Logged/NotLogged)
    - user (pouze pokud je přihlášený)
      - username
      - email
      - school_type
      - profile_image
      - bio

- api/user/logout
  - Odhlásí uživatele

- api/user/changepassword
  - Změní přihlášenému uživateli heslo
  - Vstup (POST) JSON
    - password

- api/user/login
  - Přihlásí uživatele pomocí přihlašovacího jména a hesla
  - Vstup (POST) JSON
    - username
    - password
  - Výstup (pole hodnot):
    - Pokud je přihlášení úspěšné
      - success (true)
      - status (Logged)
      - user
        - username
        - email
        - school_type
        - profile_image
        - bio
    - Pokud není přihlášení úspěšné
      - success (false)
      - message (error msg)

- api/user/register
  - Registruje uživatele
  - Vstup (POST) JSON
    - username
    - password
    - email
    - school_type (uciliste, stredniSkola, gymnazium)
  - Výstup (pole hodnot):
    - Pokud je registrace úspešná
      - createdUserId
    - Pokud je registrace neúspěšná (existuje uživatel se stejným nickem)
      - error 409
    - Pokud je registrace neúspěšná (uživatel je nyní přihlášený)
      - error 400

## Uživatelský profil
- api/profile/uploadprofileimage
  - Změní přihláenému uživateli jeho profilový obrázek
  - Vstup (POST) JSON
    - profileImage - Obrázek jako profilovka
  - 
- api/profile/getprofileimage/\<userId>
  - Vrátí obrázek, který má uživatel jako profilovou fotku

- api/profile/updatesettings
  - Změní nastavení profilu
  - Vstup (POST) JSON
    - email
    - bio