-- Vytvoření schématu a použití
CREATE SCHEMA IF NOT EXISTS `MatematikaModerne` DEFAULT CHARACTER SET utf8;
USE `MatematikaModerne`;

-- Vložení dat do tabulky `users`
INSERT INTO `users` 
  (`username`, `role`, `email`, `password`, `school_type`, `profile_image`, `bio`, `last_change`)
VALUES
  ('novak', 'učitel', 'novak@example.com', 'heslo123', 'střední škola', 'novak.png', 'Zkušený učitel matematiky, specializující se na algebru.', NOW()),
  ('svobodova', 'učitel', 'svobodova@example.com', 'heslo456', 'gymnázium', NULL, 'Specialistka na geometrii a prostorovou představivost.', NOW()),
  ('admin', 'správce', 'admin@example.com', 'adminpass', 'učiliště', NULL, 'Správce celého systému a aktualizací dat.', NOW());

-- Vložení dat do tabulky `topics`
INSERT INTO `topics` (`name`)
VALUES
  ('Algebra'),
  ('Geometrie'),
  ('Matematická analýza');

-- Vložení dat do tabulky `articles`
-- Předpokládáme, že:
--   - Uživatelem s id=1 (novak) se vloží článek o lineárních rovnicích v tématu Algebra,
--   - Uživatelem s id=2 (svobodova) se vloží článek o kruhových funkcích v tématu Geometrie,
--   - Další článek vloží uživatel id=1 (novak) v tématu Matematická analýza.
INSERT INTO `articles` 
  (`title`, `type`, `short_description`, `content`, `time_estimate`, `difficulty`, `usage_count`, `created_at`, `last_change`, `users_id`, `topics_id`)
VALUES
  ('Lineární rovnice', 'digitální', 'Krátký popis lineárních rovnic', 'Obsah článku o lineárních rovnicích se zaměřením na základní postupy řešení.', 30, 'lehké', 10, NOW(), NOW(), 1, 1),
  ('Kruhové funkce', 'fyzická', 'Praktický příklad využití kruhových funkcí', 'Obsah článku o kruhových funkcích s ukázkami pro výuku v gymnáziu.', 45, 'střední', 5, NOW(), NOW(), 2, 2),
  ('Derivace a integrály', 'digitální', 'Základní principy diferenciálního a integrálního počtu', 'Obsah článku o derivacích a integrálech, který podrobně rozebírá změny funkcí.', 60, 'těžké', 2, NOW(), NOW(), 1, 3);

-- Vložení dat do tabulky `comments`
-- Příklad komentářů ke článku s id=1 (Lineární rovnice)
INSERT INTO `comments` 
  (`text`, `created_at`, `articles_id`, `parent_comments_id`, `users_id`)
VALUES
  ('Skvělý článek, pomohl mi pochopit lineární rovnice!', NOW(), 1, NULL, 2),
  ('Souhlasím, ale určitě by bylo dobré přidat více příkladů pro lepší ilustraci.', NOW(), 1, 1, 1),
  ('Mám názor, že by se měl rozšířit popis metod řešení.', NOW(), 1, NULL, 3);

-- Příklad komentáře ke článku s id=2 (Kruhové funkce)
INSERT INTO `comments` 
  (`text`, `created_at`, `articles_id`, `parent_comments_id`, `users_id`)
VALUES
  ('Velmi inspirativní materiál, děkuji za sdílení!', NOW(), 2, NULL, 1);
