# Specifikace
Popis projektu pro potřeby vývoje, specifikace pro klientku a hodnotitelé [zde](https://docs.google.com/document/d/1JTWZOC_SSimKxD-FDXQ8EVngLr_caQhg6_3bnx7Vj5w/edit?usp=drive_link)

---

## Úvod
- Vývoj webového portálu je rozdělen do několika částí:
  - Vývoj backendu
  - Vývoj frontendu
  - Návrh a implementace databáze

---

## Frontend

### Vývojář
- **Marek Ondriáš**

### Technologie
- **HTML, CSS, TypeScript**
- **React**
- **Postman** (pro testování backend API)

### Cíle
- Vytvořit statické stránky webu
- Zpracovat data z backendu.

### Statické stránky

#### 🏠 Home Page:
- Hlavní stránka webového portálu.
- Při první návštěvě se zobrazí animace **"Vítejte na webu matematika moderně"** (0.5s).
  - Pokud se uživatel vrátí jiným způsobem (reload, přesměrování z jiné stránky), animace se nespustí.
- **Header (lišta)** obsahuje:
  - **Část 1:**
    - `Logo` (zarovnáno vlevo)
    - `Odkaz na profil` (zarovnáno vpravo)
    - `Vyhledávací okno` (zarovnáno na střed)
    - Při scrollování je část 1 přilepena nahoře.
  - **Část 2:**
    - Odkazy na další stránky: `O projektu`, `Témata`, `Ročník`

- **Tělo stránky**:
  - **Naposledy otevřené**
  - **Doporučené** (řeší backend)
  - **Nejnovější příspěvky**
  - Každá část zobrazuje **náhledy materiálů**:
    - Název, ročník, časový odhad, hodnocení, top 3 komentáře.

#### 📄 Články (Materiály k výuce)
- Každý článek reprezentuje jeden konkrétní **výukový materiál**.
- Uživatel se k němu dostane:
  - `Homepage -> Témata -> Konkrétní téma -> Podkapitola`
  - `Homepage -> Ročník -> Témata -> ...`

##### **Obsah článku**:
- **Název článku**
- **Autor**
- **Krátký popisek**
- **Datum přidání**
- **Počet využití materiálu**
- **Časový odhad**
- **Náročnost** (TODO: rozhodnout implementaci)
- **Tělo článku**: Obsahuje **interaktivní okno** (Geogebra, LaTeX, PDF prohlížeč, Kahoot apod.).
- **Sekce komentářů** (viz níže).

#### ℹ️ O projektu
- Obsahuje editovatelnou stránku s informacemi o projektu:
  - **Vytvoření projektu**
  - **Motivace vzniku**
  - **Pro koho je web určen**
  - **Historie webu**
  - **Vývoj** (kdo se podílí na vývoji, garanti, sponzoři)
  - **Jiné sekce** (např. blog)

#### 👤 Profil uživatele
- Obsahuje formulář s uživatelskými údaji:
  - **Povinné:**
    - Uživatelské jméno
    - Typ školy (_učiliště/gymnázium/střední škola_)
    - Email
    - Heslo
  - **Nepovinné:**
    - Profilový obrázek
    - Bio (stručný popis)
    - Počet vytvořených článků
- **Návrh:** Pod formulářem tabulka s odkazy na vytvořené články.

#### 💬 Komentářová sekce
- Komentáře podporují **vnořování do hloubky 3**.
- Struktura vnořených komentářů:

```yaml
Příklad:
Comment_A

    Comment_B

        CommentC
        CommentD
    
    Comment_E
```

- TODO: Vybrat optimální způsob reprezentace komentářů.
 
- [Inspirace](https://codepen.io/rush-it/pen/RwPmPJe)


---


### 🎨 Design 
 
- TODO
- Barevné palety: 
  - [color1](https://coolors.co/8fd694-7dba84-77ad78-6f8f72-504b43)
 
  - [color2](https://coolors.co/f7f052-f28123-d34e24-563f1b-38726c)

---


## Backend 
*(Detaily backend API budou specifikovány samostatně.)*

### Vývojář:
- **Vojtěch Aloy**
---


## Návrh databázového modelu 

### Vývojář:
- **Martin Opelka**

### 1. Uživatelé a profily 
**Tabulka: Users (Uživatelé)**  
- **id:**  Primární klíč (AUTO_INCREMENT)
 
- **username:**  Uživatelské jméno (VARCHAR, unikátní)

- **role:**  ENUM ('učitel', 'správce')
 
- **email:**  Emailová adresa (VARCHAR, unikátní)
 
- **password_hash:**  Uložené heslo ve formě hashe (VARCHAR)
 
- **school_type:**  Typ školy (např. ENUM s hodnotami “učiliště”, “gymnázium”, “střední škola”)
 
- **profile_image:**  URL nebo cesta k profilovému obrázku (VARCHAR, NULL pokud není)
 
- **bio:**  Stručný popis uživatele (TEXT, NULL pokud není)
 
- **created_at / updated_at:**  Časové značky vytvoření a poslední úpravy profilu

> *Poznámka:* Počet vytvořených článků lze získat pomocí agregace z tabulky článků.

---


### 2. Články a materiály 
**Tabulka: Articles (Články/Materiály)**  
- **id:**  Primární klíč
 
- **title:**  Název článku/materiálu (VARCHAR)

- **grade:**  Ročník článku INT

- **type:** ENUM ('fyzické', 'digitální')
  
- **short_description:**  Krátký popisek článku (TEXT)
 
- **content:**  Tělo článku – může obsahovat text, nebo odkaz na externí službu (LONGTEXT)

- **time_estimate:**  Časový odhad (např. v minutách, INT)
 
- **difficulty:**  Náročnost – implementace může být číselná stupnice nebo ENUM (např. “lehké”, “střední”, “těžké”)

- **usage_count:**  Počet využití materiálu (INT, výchozí 0)
 
- **created_at:**  Datum a čas přidání

- **last_change:**  Datum a čas poslední úpravy

- **author_id:**  Cizí klíč odkazující na `Users.id` – autor článku

- **rating_count** Počet hodnocení článku (100 => 100 lidí ohodnotilo článek)

- **rating_score** Celkové hodnocení článku (rozsah 0 - 5)

- **Status** Ne/Schválený
---


### 3. Komentáře 
**Tabulka: Comments (Komentáře)**  
- **id:**  Primární klíč
 
- **article_id:**  Cizí klíč odkazující na `Articles.id`
 
- **user_id:**  Cizí klíč odkazující na `Users.id` – autor komentáře
 
- **parent_comment_id:**  (NULL pokud jde o komentář první úrovně, jinak FK odkazující sám na sebe pro vnořené komentáře)
 
- **text:**  Obsah komentáře (TEXT)
 
- **created_at:**  Datum a čas přidání komentáře

> *Poznámka:* Vnořování lze omezit pomocí aplikační logiky (např. maximální hloubka 3).

---


### 4. Kategorizace obsahu (Témata a Ročník) 

Aby bylo možné články dále filtrovat a seskupovat (podle témat), lze vytvořit samostatnou tabulku:
**Tabulka: Topics (Témata)**  
- **id:**  Primární klíč
 
- **name:**  Název tématu (VARCHAR)

- **id_articles:** FK z tabulky articles

> *Poznámka:* Číselník pro tabulku articles 

---


## Vzájemné vztahy (Relace) 
 
- **Users – Articles:**  1:N
 
- **Articles – Comments:**  1:N

- **Topics - Articles:**  1:N
 
- **Comments – Comments:**  Rekurzivní vztah pro vnořené komentáře (parent-child).
 
---

