// eslint.config.js  – ESLint “flat-config” style
import js            from '@eslint/js';
import tsParser      from '@typescript-eslint/parser';
import tsPlugin      from '@typescript-eslint/eslint-plugin';
import globals       from 'globals';
import reactHooks    from 'eslint-plugin-react-hooks';
import reactRefresh  from 'eslint-plugin-react-refresh';

export default [
  /* ignore compiled output */
  { ignores: ['dist'] },

  /* ───────────── JavaScript / JSX ───────────── */
  {
    files: ['**/*.{js,jsx}'],

    languageOptions: {
      globals: globals.browser,
      ecmaVersion: 'latest',
      parserOptions: {
        ecmaVersion: 'latest',
        ecmaFeatures: { jsx: true },
        sourceType: 'module',
      },
    },

    plugins: {
      'react-hooks': reactHooks,
      'react-refresh': reactRefresh,
    },

    rules: {
      ...js.configs.recommended.rules,
      ...reactHooks.configs.recommended.rules,
      'no-unused-vars': ['error', { varsIgnorePattern: '^[A-Z_]' }],
      'react-refresh/only-export-components': [
        'warn',
        { allowConstantExport: true },
      ],
    },
  },

  /* ───────────── TypeScript / TSX ───────────── */
  {
    files: ['**/*.{ts,tsx}'],

    languageOptions: {
      parser: tsParser,
      globals: globals.browser,
      parserOptions: {
        project: './tsconfig.json',   // let ESLint read your tsconfig
        ecmaVersion: 'latest',
        ecmaFeatures: { jsx: true },
        sourceType: 'module',
      },
    },

    plugins: {
      '@typescript-eslint': tsPlugin,
      'react-hooks': reactHooks,
      'react-refresh': reactRefresh,
    },

    rules: {
      ...tsPlugin.configs.recommended.rules,
      ...reactHooks.configs.recommended.rules,
      'react-refresh/only-export-components': [
        'warn',
        { allowConstantExport: true },
      ],

      /* replace core rules with TS versions */
      'no-unused-vars': 'off',
      '@typescript-eslint/no-unused-vars': [
        'error',
        { varsIgnorePattern: '^[A-Z_]' },
      ],

      '@typescript-eslint/explicit-module-boundary-types': 'off',
    },
  },
];
